/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.internal.UploadResource;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.VariableComponent;
import com.xebialabs.xlrelease.api.v1.forms.CreateRelease;
import com.xebialabs.xlrelease.api.v1.forms.StartRelease;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import com.xebialabs.xlrelease.views.ImportResult;
import com.xebialabs.xlrelease.views.TemplateFilters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.fileupload.FileUploadException;
import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/templates")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class TemplateApi
implements ApiService {
    public static final String SERVICE_NAME = "templateApi";
    private ReleaseActorService releaseActorService;
    private PermissionChecker permissions;
    private ReleaseService releaseService;
    private ReleaseSearchService releaseSearchService;
    private TemplateImporter templateImporter;
    private UploadResource uploadResource;
    private VariableComponent variableComponent;
    private CiIdService ciIdService;
    private TeamFacade teamFacade;

    @Autowired
    public TemplateApi(ReleaseActorService releaseActorService, PermissionChecker permissions, ReleaseService releaseService, ReleaseSearchService releaseSearchService, TemplateImporter templateImporter, UploadResource uploadResource, VariableComponent variableComponent, CiIdService ciIdService, TeamFacade teamFacade) {
        this.releaseActorService = releaseActorService;
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.releaseSearchService = releaseSearchService;
        this.templateImporter = templateImporter;
        this.uploadResource = uploadResource;
        this.variableComponent = variableComponent;
        this.ciIdService = ciIdService;
        this.teamFacade = teamFacade;
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @PublicApiMember
    @Timed
    public List<Release> getTemplates(@QueryParam(value="title") String title, @QueryParam(value="tag") List<String> tags, @DefaultValue(value="0") @QueryParam(value="page") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long resultsPerPage, @DefaultValue(value="1") @QueryParam(value="depth") Integer depth) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        TemplateFilters templateFilters = new TemplateFilters();
        templateFilters.setTitle(title);
        templateFilters.setTags(tags);
        ReleaseSearchResult searchResult = this.releaseSearchService.searchTemplates(templateFilters, page, resultsPerPage, depth);
        return searchResult.getReleases();
    }

    @PublicApiMember
    @Timed
    public List<Release> getTemplates(@QueryParam(value="title") String filter) {
        return this.getTemplates(filter, null, 0L, 100L, 1);
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    @Timed
    public Release updateTemplate(@PathParam(value="templateId") String templateId, Release template) {
        this.permissions.checkEdit(templateId);
        return this.releaseActorService.updateTemplate(templateId, template);
    }

    @PublicApiMember
    @Timed
    public Release updateTemplate(Release template) {
        return this.updateTemplate(template.getId(), template);
    }

    @POST
    @PublicApiMember
    @Timed
    public Release createTemplate(Release template) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        CiHelper.stripChildrenCis((ConfigurationItem)template);
        Checks.checkArgument((boolean)template.hasTitle(), (String)"Template title is mandatory", (Object[])new Object[0]);
        Checks.checkArgument((boolean)template.hasValidStartDates(), (String)"Dates are not valid", (Object[])new Object[0]);
        Checks.checkArgument((boolean)template.isTemplate(), (String)"Only templates can be created", (Object[])new Object[0]);
        return this.releaseService.createTemplate(template);
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"application/json"})
    @PublicApiMember
    @Timed
    public List<ImportResult> importTemplate(String json, @QueryParam(value="folderId") String folderId) {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes());
        if (Ids.isNullId((String)folderId)) {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, folderId);
        }
        return this.templateImporter.importReleaseStream(stream, true, folderId);
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Timed
    public List<ImportResult> importTemplateAsXlr(@Context HttpServletRequest request, @QueryParam(value="folderId") String folderId) throws IOException, FileUploadException {
        return this.uploadResource.importTemplates(request, folderId);
    }

    @GET
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    @Timed
    public Release getTemplate(@PathParam(value="templateId") String templateId) {
        Release template = this.releaseService.findById(templateId);
        this.permissions.checkView(template);
        return template;
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteTemplate(@PathParam(value="templateId") String templateId) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        this.releaseActorService.deleteTemplate(templateId);
    }

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/create")
    @PublicApiMember
    @Timed
    public Release create(@PathParam(value="templateId") String templateId, CreateRelease createRelease) {
        this.permissions.checkIsAllowedToCreateReleaseFromTemplate(templateId);
        Checks.checkArgument((createRelease.getReleaseTitle() != null ? 1 : 0) != 0, (String)"Release title is mandatory", (Object[])new Object[0]);
        Release releaseMetadata = this.releaseService.findById(templateId);
        Checks.checkArgument((boolean)releaseMetadata.isTemplate(), (String)String.format("%s is not a template", templateId), (Object[])new Object[0]);
        releaseMetadata.setId(null);
        releaseMetadata.setTitle(createRelease.getReleaseTitle());
        releaseMetadata.setVariableValues(createRelease.getReleaseVariables());
        releaseMetadata.setPasswordVariableValues(createRelease.getReleasePasswordVariables());
        releaseMetadata.setAutoStart(createRelease.getAutoStart());
        this.releaseService.setDatesFromTemplate(releaseMetadata, releaseMetadata, createRelease.hasScheduledStartDate() ? new LocalDateTime((Object)createRelease.getScheduledStartDate()) : LocalDateTime.now());
        VariablePersistenceHelper.fixUpVariableIds(releaseMetadata.getId(), releaseMetadata.getVariables(), this.ciIdService);
        return this.releaseService.createFromTemplate(templateId, releaseMetadata);
    }

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/start")
    @PublicApiMember
    @Timed
    public Release start(@PathParam(value="templateId") String templateId, StartRelease startRelease) {
        Release release = this.create(templateId, startRelease);
        return this.releaseActorService.startRelease(release.getId(), User.AUTHENTICATED_USER);
    }

    @GET
    @Path(value="/{templateId:.*Release[^/]*}/variables")
    @PublicApiMember
    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(@PathParam(value="templateId") String templateId) {
        return this.variableComponent.getVariables(templateId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="variableId") String variableId) {
        return this.variableComponent.getVariable(variableId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/possibleValues")
    @PublicApiMember
    @Timed
    public Collection<Object> getVariablePossibleValues(@PathParam(value="variableId") String variableId) {
        return this.variableComponent.getVariablePossibleValues(variableId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/used")
    @PublicApiMember
    @Timed
    public Boolean isVariableUsed(@PathParam(value="variableId") String variableId) {
        return this.variableComponent.isVariableUsed(variableId);
    }

    @POST
    @Path(value="/{variableId:.*/Variable[^/]*}/replace")
    @PublicApiMember
    @Timed
    public void replaceVariable(@PathParam(value="variableId") String variableId, VariableOrValue variableOrValue) {
        this.variableComponent.replaceVariable(variableId, variableOrValue);
    }

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteVariable(@PathParam(value="variableId") String variableId) {
        this.variableComponent.deleteVariable(variableId);
    }

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/variables")
    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="templateId") String templateId, Variable variable) {
        return this.variableComponent.createVariable(templateId, variable);
    }

    @PUT
    @Path(value="/{releaseId:.*Release[^/]*}/variables")
    @PublicApiMember
    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(@PathParam(value="releaseId") String releaseId, List<com.xebialabs.xlrelease.domain.variables.Variable> variables) {
        return this.variableComponent.updateVariables(releaseId, variables);
    }

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="variableId") String variableId, com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variableId, variable);
    }

    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variable.getId(), variable);
    }

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    @Timed
    public List<String> getPermissions() {
        return XLReleasePermissions.getTemplatePermissions();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/]*}/teams")
    @PublicApiMember
    @Timed
    public List<TeamView> getTeams(@PathParam(value="templateId") String templateId) {
        return this.teamFacade.getTeams(templateId);
    }

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/teams")
    @PublicApiMember
    @Timed
    public List<TeamView> setTeams(@PathParam(value="templateId") String templateId, List<TeamView> teamDtos) {
        return this.teamFacade.setTeams(templateId, teamDtos);
    }
}

