/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.db.AttachmentInfo;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\r\rq!B\u0001\u0003\u0011\u0003Y\u0011\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\tBe\u000eD\u0017N^5oON+'O^5dKN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001\"\u0002\u000e\u000e\t\u0003Y\u0012A\u00073fg\u0016\u0014\u0018.\u00197ju\u0016\f%o\u00195jm\u0016$'+\u001a7fCN,Gc\u0001\u000f#_A\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004B\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0005r\"a\u0002*fY\u0016\f7/\u001a\u0005\u0006Ge\u0001\r\u0001J\u0001\fe\u0016dW-Y:f\u0015N|g\u000e\u0005\u0002&Y9\u0011aE\u000b\t\u0003OIi\u0011\u0001\u000b\u0006\u0003S)\ta\u0001\u0010:p_Rt\u0014BA\u0016\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\u0012\u0002\"\u0002\u0019\u001a\u0001\u0004\t\u0014A\u0003:fa>\u001c\u0018\u000e^8ssB\u0011!GN\u0007\u0002g)\u0011\u0001\u0007\u000e\u0006\u0003k\u0019\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003oM\u0012\u0011CU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\r\u0011q!\u0001A\u001d\u0014\u0007a\u0002\"\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005)1\u000f\u001c45U*\tq(\u0001\u0005he&T(\u0010\\3e\u0013\t\tEHA\u0004M_\u001e<\u0017N\\4\t\u0011\rC$\u0011!Q\u0001\n\u0011\u000b\u0001#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d#\u0011A\u00013c\u0013\tIeI\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\"A1\n\u000fB\u0001B\u0003%A*\u0001\fbe\u000eD\u0017N^3e%\u0016dW-Y:fgN+\u0017M]2i!\t)U*\u0003\u0002O\r\n1\u0012I]2iSZ,GMU3mK\u0006\u001cXm]*fCJ\u001c\u0007\u000e\u0003\u0005Qq\t\u0005\t\u0015!\u0003R\u0003y\t'o\u00195jm\u0016$\u0017i\u0019;jm&$\u0018\u0010T8hgN+'/[1mSj,'\u000f\u0005\u0002\r%&\u00111K\u0001\u0002\u001f\u0003J\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJD\u0001\"\u0016\u001d\u0003\u0002\u0003\u0006I!M\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\u0002C,9\u0005\u0003\u0005\u000b\u0011\u0002-\u0002=\r|W\u000e\u001d7fi\u0016$'+\u001a7fCN,7/\u0012=q_J$8+\u001a:wS\u000e,\u0007C\u0001\u0007Z\u0013\tQ&AA\u000fD_6\u0004H.\u001a;fIJ+G.Z1tK\u0016C\bo\u001c:u'\u0016\u0014h/[2f\u0011!a\u0006H!A!\u0002\u0013i\u0016!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011a\fY\u0007\u0002?*\u0011\u0001\u0007B\u0005\u0003C~\u0013\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!\u0019\u0007H!A!\u0002\u0013!\u0017\u0001\u00063fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002_K&\u0011am\u0018\u0002\u0015\t\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=\t\u000b]AD\u0011\u00015\u0015\u0011%T7\u000e\\7o_B\u0004\"\u0001\u0004\u001d\t\u000b\r;\u0007\u0019\u0001#\t\u000b-;\u0007\u0019\u0001'\t\u000bA;\u0007\u0019A)\t\u000bU;\u0007\u0019A\u0019\t\u000b];\u0007\u0019\u0001-\t\u000bq;\u0007\u0019A/\t\u000b\r<\u0007\u0019\u00013)\u0005\u001d\u0014\bCA:\u007f\u001b\u0005!(BA;w\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003ob\fqAZ1di>\u0014\u0018P\u0003\u0002zu\u0006)!-Z1og*\u00111\u0010`\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ0A\u0002pe\u001eL!a ;\u0003\u0013\u0005+Ho\\<je\u0016$\u0007bBA\u0002q\u0011\u0005\u0011QA\u0001\u000fCJ\u001c\u0007.\u001b<f%\u0016dW-Y:f)\u0019\t9!!\u0004\u0002\u0012A\u0019\u0011#!\u0003\n\u0007\u0005-!C\u0001\u0003V]&$\bbBA\b\u0003\u0003\u0001\r\u0001H\u0001\be\u0016dW-Y:f\u0011!\t\u0019\"!\u0001A\u0002\u0005U\u0011A\u0005:fY\u0016\f7/Z!ui\u0006\u001c\u0007.\\3oiN\u0004b!a\u0006\u0002\"\u0005\u0015RBAA\r\u0015\u0011\tY\"!\b\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0011a\u0015n\u001d;\u0011\u0007u\t9#C\u0002\u0002*y\u0011!\"\u0011;uC\u000eDW.\u001a8uQ\u0011\t\t!!\f\u0011\t\u0005=\u00121H\u0007\u0003\u0003cQ1!^A\u001a\u0015\u0011\t)$a\u000e\u0002\u000f5,GO]5dg*\u0019\u0011\u0011\b\u0005\u0002\u0011\r|G-\u00195bY\u0016LA!!\u0010\u00022\t)A+[7fI\"9\u0011\u0011\t\u001d\u0005\u0002\u0005\r\u0013AC4fiJ+G.Z1tKR\u0019A$!\u0012\t\u000f\u0005\u001d\u0013q\ba\u0001I\u0005I!/\u001a7fCN,\u0017\n\u001a\u0015\u0005\u0003\u007f\ti\u0003C\u0004\u0002Na\"\t!a\u0014\u0002\u001f\u001d,GOU3mK\u0006\u001cX\rV5uY\u0016$2\u0001JA)\u0011\u001d\t9%a\u0013A\u0002\u0011BC!a\u0013\u0002.!9\u0011q\u000b\u001d\u0005\u0002\u0005e\u0013\u0001C4fiBC\u0017m]3\u0015\t\u0005m\u0013\u0011\r\t\u0004;\u0005u\u0013bAA0=\t)\u0001\u000b[1tK\"9\u00111MA+\u0001\u0004!\u0013a\u00029iCN,\u0017\n\u001a\u0015\u0005\u0003+\ni\u0003C\u0004\u0002ja\"\t!a\u001b\u0002\u000f\u001d,G\u000fV1tWR!\u0011QNA:!\ri\u0012qN\u0005\u0004\u0003cr\"\u0001\u0002+bg.Dq!!\u001e\u0002h\u0001\u0007A%\u0001\u0004uCN\\\u0017\n\u001a\u0015\u0005\u0003O\ni\u0003C\u0004\u0002|a\"\t!! \u0002\u0017\u001d,GOV1sS\u0006\u0014G.\u001a\u000b\u0005\u0003\u007f\nY\t\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t)IH\u0001\nm\u0006\u0014\u0018.\u00192mKNLA!!#\u0002\u0004\nAa+\u0019:jC\ndW\rC\u0004\u0002\u000e\u0006e\u0004\u0019\u0001\u0013\u0002\u0015Y\f'/[1cY\u0016LE\r\u000b\u0003\u0002z\u00055\u0002bBAJq\u0011\u0005\u0011QS\u0001\u0007KbL7\u000f^:\u0015\t\u0005]\u0015Q\u0014\t\u0004#\u0005e\u0015bAAN%\t9!i\\8mK\u0006t\u0007bBAP\u0003#\u0003\r\u0001J\u0001\u0005G&LE\r\u000b\u0003\u0002\u0012\u00065\u0002bBASq\u0011\u0005\u0011qU\u0001\rKbL7\u000f^:Cs:\u000bW.\u001a\u000b\u0005\u0003/\u000bI\u000bC\u0004\u0002,\u0006\r\u0006\u0019\u0001\u0013\u0002\u0017I,G.Z1tK:\u000bW.\u001a\u0015\u0005\u0003G\u000bi\u0003C\u0004\u00022b\"\t!a-\u0002!\rDWmY6O_R\f%o\u00195jm\u0016$G\u0003BA\u0004\u0003kCq!a(\u00020\u0002\u0007A\u0005\u000b\u0003\u00020\u00065\u0002bBA^q\u0011\u0005\u0011QX\u0001\u0011CR$\u0018m\u00195nK:$X\t_5tiN$B!a&\u0002@\"9\u0011\u0011YA]\u0001\u0004!\u0013\u0001D1ui\u0006\u001c\u0007.\\3oi&#\u0007\u0006BA]\u0003[Aq!a29\t\u0003\tI-A\u0007hKR\fE\u000f^1dQ6,g\u000e\u001e\u000b\u0005\u0003K\tY\rC\u0004\u0002B\u0006\u0015\u0007\u0019\u0001\u0013)\t\u0005\u0015\u0017Q\u0006\u0005\b\u0003#DD\u0011AAj\u0003M9W\r^!ui\u0006\u001c\u0007.\\3oi>\u0003H/[8o)\u0011\t).a7\u0011\u000bE\t9.!\n\n\u0007\u0005e'C\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u0003\fy\r1\u0001%Q\u0011\ty-!\f\t\u000f\u0005\u0005\b\b\"\u0001\u0002d\u0006q1/Z1sG\"\u0014V\r\\3bg\u0016\u001cH\u0003BAs\u0003O\u0004R!a\u0006\u0002\"qA\u0001\"!;\u0002`\u0002\u0007\u00111^\u0001\bM&dG/\u001a:t!\u0011\ti/a?\u000e\u0005\u0005=(\u0002BAy\u0003g\fQAZ8s[NTA!!>\u0002x\u0006\u0011a/\r\u0006\u0004\u0003s$\u0011aA1qS&!\u0011Q`Ax\u0005=\u0011V\r\\3bg\u0016\u001ch)\u001b7uKJ\u001c\b\u0006BAp\u0003[Aq!!99\t\u0003\u0011\u0019\u0001\u0006\u0005\u0002f\n\u0015!q\u0001B\t\u0011!\tIO!\u0001A\u0002\u0005-\b\u0002\u0003B\u0005\u0005\u0003\u0001\rAa\u0003\u0002\u000b1LW.\u001b;\u0011\u0007E\u0011i!C\u0002\u0003\u0010I\u0011A\u0001T8oO\"A!1\u0003B\u0001\u0001\u0004\u0011Y!\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0005\u0005\u0003\ti\u0003C\u0004\u0003\u001aa\"\tAa\u0007\u00021\u0019Lg\u000eZ!sG\"Lg/\u00192mKJ+G.Z1tK&#7\u000f\u0006\u0004\u0003\u001e\t=\"\u0011\b\t\u0006\u0005?\u0011I\u0003\n\b\u0005\u0005C\u0011)CD\u0002(\u0005GI\u0011aE\u0005\u0004\u0005O\u0011\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005W\u0011iCA\u0002TKFT1Aa\n\u0013\u0011!\u0011\tDa\u0006A\u0002\tM\u0012\u0001\u00023bi\u0016\u0004B!a\u0006\u00036%!!qGA\r\u0005\u0011!\u0015\r^3\t\u0011\tm\"q\u0003a\u0001\u0005{\t\u0001\u0002]1hKNK'0\u001a\t\u0005\u0005\u007f\u0011)%\u0004\u0002\u0003B)!!1IA\u000f\u0003\u0011a\u0017M\\4\n\t\t\u001d#\u0011\t\u0002\b\u0013:$XmZ3sQ\u0011\u00119\"!\f\t\u000f\t5\u0003\b\"\u0001\u0003P\u0005q\u0012M]2iSZ,\u0017\t\u001c7J]\u000e|W.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\u0003\u000f\u0011\t\u0006C\u0004\u0002H\t-\u0003\u0019\u0001\u0013)\t\t-\u0013Q\u0006\u0005\b\u0005/BD\u0011\u0001B-\u0003)9W\r^!mYR\u000bwm\u001d\u000b\u0005\u00057\u0012\t\u0007E\u0003\u0002\u0018\tuC%\u0003\u0003\u0003`\u0005e!aA*fi\"A!1\rB+\u0001\u0004\u0011)'A\u0006mS6LGOT;nE\u0016\u0014\bcA\t\u0003h%\u0019!\u0011\u000e\n\u0003\u0007%sG\u000f\u000b\u0003\u0003V\u00055\u0002b\u0002B8q\u0011\u0005!\u0011O\u0001\u0007I\u0016dW\r^3\u0015\t\u0005\u001d!1\u000f\u0005\b\u0003\u000f\u0012i\u00071\u0001%Q\u0011\u0011i'!\f\t\u000f\u0005\u0005\b\b\"\u0003\u0003zQA\u0011Q\u001dB>\u0005{\u0012\t\t\u0003\u0005\u0002j\n]\u0004\u0019AAv\u0011!\u0011IAa\u001eA\u0002\t}\u0004#B\t\u0002X\n-\u0001\u0002\u0003B\n\u0005o\u0002\rAa \t\u000f\t\u0015\u0005\b\"\u0003\u0003\b\u0006\u0001r-\u001a;SK2,\u0017m]3PaRLwN\u001c\u000b\u0005\u0005\u0013\u0013Y\t\u0005\u0003\u0012\u0003/d\u0002bBA$\u0005\u0007\u0003\r\u0001\n\u0005\b\u0005\u001fCD\u0011\u0002BI\u000399W\r\u001e)iCN,w\n\u001d;j_:$BAa%\u0003\u0016B)\u0011#a6\u0002\\!9\u00111\rBG\u0001\u0004!\u0003b\u0002BMq\u0011%!1T\u0001\u000eO\u0016$H+Y:l\u001fB$\u0018n\u001c8\u0015\t\tu%q\u0014\t\u0006#\u0005]\u0017Q\u000e\u0005\b\u0003k\u00129\n1\u0001%\u0011\u001d\u0011\u0019\u000b\u000fC\u0005\u0005K\u000b\u0011cZ3u-\u0006\u0014\u0018.\u00192mK>\u0003H/[8o)\u0011\u00119K!+\u0011\u000bE\t9.a \t\u000f\u00055%\u0011\u0015a\u0001I!9!Q\u0016\u001d\u0005\n\t=\u0016AH1sG\"Lg/Z!mY>+HoZ8j]\u001e$U\r]3oI\u0016t7-[3t)\u0011\u0011\tL!/\u0011\r\t}!\u0011\u0006BZ!\ri\"QW\u0005\u0004\u0005os\"A\u0003#fa\u0016tG-\u001a8ds\"9\u0011q\u0002BV\u0001\u0004a\u0002f\u0005\u001d\u0003>\n-'Q\u001aBi\u0005'\u0014iNa8\u0003j\n-\b\u0003\u0002B`\u0005\u000fl!A!1\u000b\u0007U\u0014\u0019MC\u0002\u0003Fj\f1\u0002\u001e:b]N\f7\r^5p]&!!\u0011\u001aBa\u00055!&/\u00198tC\u000e$\u0018n\u001c8bY\u0006)a/\u00197vK\u0006\u0012!qZ\u0001\u001ce\u0016\u0004xN\u001d;j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0002\u0017A\u0014x\u000e]1hCRLwN\u001c\u0013\u0003\u0005+LAAa6\u0003Z\u0006A!+R)V\u0013J+EI\u0003\u0003\u0003\\\n\u0005\u0017a\u0003)s_B\fw-\u0019;j_:\f\u0011\"[:pY\u0006$\u0018n\u001c8%\u0005\t\u0005\u0018\u0002\u0002Br\u0005K\faBU#B\t~\u001bu*T'J)R+EI\u0003\u0003\u0003h\n\u0005\u0017!C%t_2\fG/[8o\u0003-\u0011x\u000e\u001c7cC\u000e\\gi\u001c:-\u0005\t58E\u0001Bx!\u0011\u0011yB!=\n\t\tM(Q\u0006\u0002\n)\"\u0014xn^1cY\u0016D3\u0001\u000fB|!\u0011\u0011IPa@\u000e\u0005\tm(b\u0001B\u007fu\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\r\u0005!1 \u0002\b'\u0016\u0014h/[2f\u0001")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void archiveRelease(Release release, java.util.List<Attachment> releaseAttachments) {
        Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
        String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
        if (!release.isTutorial()) {
            String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
            this.archivedReleases.insert(release, serializedRelease, activityLogsJson);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releaseAttachments).asScala()).foreach((Function1 & Serializable & scala.Serializable)attachment -> {
                ArchivingService.$anonfun$archiveRelease$1(this, release, attachment);
                return BoxedUnit.UNIT;
            });
        }
        if (this.releaseRepository.exists(release.getId())) {
            this.releaseRepository.delete(release.getId());
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running release ", " through export hooks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getId()})));
        this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
    }

    @Timed
    public Release getRelease(String releaseId) {
        return (Release)this.getReleaseOption(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases.getReleaseTitle(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getPhaseOption(phaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)phaseId)})), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getTaskOption(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)taskId)})), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)variableId)})), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases.exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getPhaseOption(ciId).isDefined() : (Ids.isTaskId((String)ciId) ? this.getTaskOption(ciId).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases.existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases.exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot perform this operation on archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)ciId)})), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases.attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived attachment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachmentId})), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)release -> $this.archivedReleases.getAttachment(attachmentId).flatMap((Function1 & Serializable & scala.Serializable)overthereFile -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).map((Function1 & Serializable & scala.Serializable)attachment -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.releaseRepository.findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (Seq<String>)((Seq)Seq$.MODULE$.empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.archivedReleases.findAllTags(limitNumber)).asJava();
    }

    @Timed
    public void delete(String releaseId) {
        this.archivedReleases.delete(releaseId);
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        filters.checkConsistency();
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), List$.MODULE$.canBuildFrom())).asJava();
    }

    private Option<Release> getReleaseOption(String releaseId) {
        return this.archivedReleases.getRelease(releaseId).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = $this.archivedReleases.getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find attachment ", " of release ", " in the attachments table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), releaseId})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private Option<Phase> getPhaseOption(String phaseId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)phaseId)).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getPhase(phaseId)));
    }

    private Option<Task> getTaskOption(String taskId) {
        return this.getPhaseOption(Ids.phaseIdFrom((String)taskId)).flatMap((Function1 & Serializable & scala.Serializable)phase -> Option$.MODULE$.apply((Object)phase.getTask(taskId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId)).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$3))));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        void var2_2;
        Buffer dependencies = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$4.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$5)));
        dependencies.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.archive();
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$3(ArchivingService $this, Release release$1, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases.insertAttachment(release$1.getId(), new AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$1(ArchivingService $this, Release release$1, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable & scala.Serializable)data -> {
            ArchivingService.$anonfun$archiveRelease$3($this, release$1, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        Seq rawDependenciesToArchive = (Seq)tuple2._2();
        Release referencingRelease = $this.releaseRepository.findById(referencingReleaseId);
        Buffer dependenciesToArchive = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(referencingRelease.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)rawDependenciesToArchive.contains((Object)d)));
        dependenciesToArchive.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.archive();
            return BoxedUnit.UNIT;
        });
        $this.dependencyRepository.archive(referencingRelease, (Seq<Dependency>)dependenciesToArchive);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$3) {
        String string = x$3.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$5) {
        return !x$5.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        Logging.$init$((Logging)this);
    }
}

