/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutedEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=false)
public class ReleaseTriggerSubscriber {
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;

    @Autowired
    public ReleaseTriggerSubscriber(ReleaseActorService releaseActorService, XLReleaseEventBus eventBus) {
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
    }

    @PostConstruct
    public void postConstruct() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBus.deregister(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void releaseExecuted(ReleaseExecutedEvent releaseExecutedEvent) {
        this.releaseActorService.stopSchedulerPolling(releaseExecutedEvent.release().getId());
        if (releaseExecutedEvent.release().isCreatedFromTrigger()) {
            this.releaseActorService.markTriggeredReleaseExecuted(releaseExecutedEvent.release().getOriginTemplateId());
        }
    }
}

