/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.userdata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.xlrelease.userdata.UserData;
import com.xebialabs.xlrelease.userdata.UserDataProvider;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class UserDataProviderCache
implements UserDataProvider {
    private static final int EXPIRATION_DELAY_IN_MINUTES = 30;
    private UserDataProvider userDataProvider;
    private LoadingCache<String, UserData> userDataCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, UserData>(){

        public UserData load(String username) throws Exception {
            return UserDataProviderCache.this.userDataProvider.getUserData(username);
        }
    });

    UserDataProviderCache(UserDataProvider userDataProvider) {
        this.userDataProvider = userDataProvider;
    }

    public void clearCache() {
        this.userDataCache.invalidateAll();
    }

    @Override
    public UserData getUserData(String username) {
        try {
            return (UserData)this.userDataCache.get((Object)username);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

