/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.converters.PlanItemConverter;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PhaseViewConverter
implements PlanItemConverter {
    private TasksViewConverter tasksViewConverter;

    @Autowired
    public PhaseViewConverter(TasksViewConverter tasksViewConverter) {
        this.tasksViewConverter = tasksViewConverter;
    }

    public PhaseFullView toFullView(Phase phase, List<Type> allowedTaskTypesForAuthenticatedUser) {
        PhaseFullView phaseFullView = new PhaseFullView();
        this.populatePlanItemView(phaseFullView, (PlanItem)phase);
        phaseFullView.setOrigin(!StringUtils.hasText((String)phase.getOriginId()));
        boolean isPhaseCopied = phase.isPhaseCopied();
        if (isPhaseCopied) {
            phaseFullView.setMostRecentCopy(false);
        } else {
            phaseFullView.setMostRecentCopy(phase.isLatestCopy());
        }
        phaseFullView.setOriginId(phase.getOriginId());
        phaseFullView.setStatus(phase.getStatus());
        if (phase.getTasks() != null) {
            phaseFullView.setTasks(this.tasksViewConverter.toFullView(phase.getTasks(), allowedTaskTypesForAuthenticatedUser));
            int taskFailureCount = 0;
            int taskFlaggedCount = 0;
            int taskDelayCount = 0;
            for (Task task : phase.getAllTasks()) {
                if (task.hasBeenDelayed()) {
                    ++taskDelayCount;
                }
                if (task.hasBeenFlagged()) {
                    ++taskFlaggedCount;
                }
                taskFailureCount += task.getFailuresCount();
            }
            phaseFullView.setTaskDelayCount(taskDelayCount);
            phaseFullView.setTaskFlaggedCount(taskFlaggedCount);
            phaseFullView.setTaskFailureCount(taskFailureCount);
        }
        if (phase.getStartGates() != null) {
            phaseFullView.setStartGates(this.tasksViewConverter.toFullView(phase.getStartGates(), allowedTaskTypesForAuthenticatedUser));
            phaseFullView.setStartGatesOpen(phase.areStartGatesOpen());
        }
        if (phase.getEndGates() != null) {
            phaseFullView.setEndGates(this.tasksViewConverter.toFullView(phase.getEndGates(), allowedTaskTypesForAuthenticatedUser));
            phaseFullView.setEndGatesOpen(phase.areEndGatesOpen());
        }
        phaseFullView.setColor(phase.getColor());
        return phaseFullView;
    }
}

