/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.customscripts;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ExportHook;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.TaskTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScriptTypes {
    private Collection<Type> pythonScriptTypes = this.getTypes("Custom Tasks", PythonScript.class);
    private Collection<Type> releaseTriggerTypes = this.getTypes("Release triggers", ReleaseTrigger.class);
    private Collection<Type> exportHookTypes = this.getTypes("Export hooks", ExportHook.class);
    public static final Set<Type> UNKNOWN_TYPES = Collections.singleton(CustomScriptTask.UNKNOWN_TYPE);
    private static final Logger logger = LoggerFactory.getLogger(ScriptTypes.class);

    public Collection<Type> getPythonScriptTypes() {
        return this.pythonScriptTypes;
    }

    public Collection<Type> getReleaseTriggerTypes() {
        return this.releaseTriggerTypes;
    }

    public Collection<Type> getExportHookTypes() {
        return this.exportHookTypes;
    }

    private List<Type> getTypes(String label, Class<? extends ConfigurationItem> type) {
        List<Type> types = TaskTypes.getTypes(type).stream().filter(t -> !UNKNOWN_TYPES.contains(t)).collect(Collectors.toList());
        StringBuffer typeList = new StringBuffer("\n");
        for (Type t2 : types) {
            typeList.append("  ").append(t2).append("\n");
        }
        logger.info("{}: {}", (Object)label, (Object)typeList);
        return types;
    }
}

