/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.createrelease;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CreateReleaseTaskViewConverter
extends BaseTaskViewConverter<CreateReleaseTask> {
    private final ConfigurationRepository configurationRepository;
    private final ReleaseSearchService releaseSearchService;

    @Autowired
    public CreateReleaseTaskViewConverter(ConfigurationRepository configurationRepository, ReleaseSearchService releaseSearchService) {
        this.configurationRepository = configurationRepository;
        this.releaseSearchService = releaseSearchService;
    }

    @Override
    public TaskFullView toFullView(CreateReleaseTask task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView v = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        v.setNewReleaseTitle(task.getNewReleaseTitle());
        v.setTemplateId(task.getTemplateId());
        v.setFolderId(task.getFolderId());
        v.setVariables(task.getTemplateVariables());
        v.setCreatedReleaseId(task.getCreatedReleaseId());
        if (StringUtils.hasText((String)task.getCreatedReleaseId()) && task.isDone()) {
            this.releaseSearchService.getTitle(task.getCreatedReleaseId()).foreach(t -> {
                v.setCreatedReleaseTitle((String)t);
                return null;
            });
        }
        v.setStartRelease(task.getStartRelease());
        v.setReleaseTags(task.getReleaseTags());
        if (task.hasProperty("riskProfile")) {
            this.setRiskProfileFromTask(task, v);
        }
        return v;
    }

    private void setRiskProfileFromTask(CreateReleaseTask task, TaskFullView view) {
        BaseConfiguration configuration = (BaseConfiguration)task.getProperty("riskProfile");
        if (null != configuration && StringUtils.hasText((String)configuration.getId())) {
            view.setRiskProfileId(configuration.getId());
        }
    }

    @Override
    protected CreateReleaseTask fromView(TaskFullView view) {
        VariableHelper.collectVariables((Object)view.getTemplateId()).forEach(view::setTemplateId);
        CreateReleaseTask task = TaskBuilder.newCreateReleaseTask().withNewReleaseTitle(view.getNewReleaseTitle()).withTemplateId(view.getTemplateId()).withFolderId(view.getFolderId()).withVariables(view.getVariables()).withCreatedReleaseId(view.getCreatedReleaseId()).withStartRelease(view.getStartRelease()).withReleaseTags(view.getReleaseTags()).build();
        if (task.hasProperty("riskProfile")) {
            this.setRiskProfileFromView(view, task);
        }
        return task;
    }

    private void setRiskProfileFromView(TaskFullView view, CreateReleaseTask task) {
        String configurationId = view.getRiskProfileId();
        if (StringUtils.hasText((String)configurationId)) {
            Object configuration = this.configurationRepository.read(configurationId);
            PropertyDescriptor riskProfilePD = task.getType().getDescriptor().getPropertyDescriptor("riskProfile");
            Checks.checkArgument((boolean)configuration.getType().getDescriptor().isAssignableTo(riskProfilePD.getReferencedType()), (String)("Can't assign property of type " + configuration.getType().getName() + " to property " + riskProfilePD.getName()), (Object[])new Object[0]);
            task.setProperty("riskProfile", configuration);
        }
    }

    @Override
    protected Class<CreateReleaseTask> getTaskClass() {
        return CreateReleaseTask.class;
    }
}

