/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.export.TemplateImportUpgradesProvider;
import com.xebialabs.xlrelease.export.TemplateJsonHelper;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xlrelease.upgrade.ImportUpgrade;
import com.xebialabs.xlrelease.upgrade.UpgradeResult;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateImportUpgrader {
    private TemplateImportUpgradesProvider templateImportUpgradesProvider;
    private RepositoryVersionService repositoryVersionService;

    @Autowired
    public TemplateImportUpgrader(TemplateImportUpgradesProvider templateImportUpgradesProvider, RepositoryVersionService repositoryVersionService) {
        this.templateImportUpgradesProvider = templateImportUpgradesProvider;
        this.repositoryVersionService = repositoryVersionService;
    }

    public UpgradeResult upgrade(JSONObject release, String packageVersionId) {
        try {
            ArrayList warnings = Lists.newArrayList();
            this.resetUnknownTasks(release, warnings);
            Version currentVersion = this.repositoryVersionService.readVersionOfComponent(Components.XL_RELEASE_COMPONENT);
            Version packageVersion = this.getVersion(packageVersionId);
            if (!currentVersion.equals((Object)packageVersion)) {
                Preconditions.checkArgument((packageVersion.compareTo(currentVersion) <= 0 ? 1 : 0) != 0, (Object)String.format("The package was exported from a later data model version '%s' and cannot be imported on '%s'", packageVersionId, currentVersion.getVersion()));
                ArrayList upgrades = Lists.newArrayList(this.templateImportUpgradesProvider.getUpgrades());
                this.sortUpgrades(upgrades);
                for (ImportUpgrade upgrade : upgrades) {
                    if (upgrade.getUpgradeVersion().compareTo(packageVersion) <= 0) continue;
                    warnings.addAll(upgrade.performUpgrade(release).getWarnings());
                }
            }
            return new UpgradeResult(true, warnings);
        }
        catch (JSONException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Version getVersion(String packageVersionId) {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)packageVersionId);
    }

    private void resetUnknownTasks(JSONObject release, List<String> warnings) throws JSONException {
        List<JSONObject> tasksFromRelease = TemplateJsonHelper.getTasksFromRelease(release);
        for (JSONObject task : tasksFromRelease) {
            JSONObject pythonScript;
            if (!TemplateJsonHelper.isCustomScriptTask(task) || !TemplateJsonHelper.typeNotFound(pythonScript = task.getJSONObject("pythonScript"))) continue;
            TemplateJsonHelper.resetToManualTask(task);
            JSONObject phase = TemplateJsonHelper.getPhase(task, release);
            String warningMessage = String.format("Task '%s' in Phase '%s' has been replaced by a manual task. The task of type '%s' could not be found because of a missing plugin.", task.getString("title"), phase.get("title"), pythonScript.getString("type"));
            TemplateJsonHelper.flagTask(task, warningMessage);
            warnings.add(warningMessage);
        }
    }

    private void sortUpgrades(List<ImportUpgrade> upgrades) {
        upgrades.sort((o1, o2) -> ComparisonChain.start().compare((Comparable)o1.getUpgradeVersion(), (Comparable)o2.getUpgradeVersion()).result());
    }
}

