/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.domain.events.FolderVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.IdMatchers$FolderId$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\u0007\u000e\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003F\u0001\u0011\u0005a\tC\u0003g\u0001\u0011\u0005q\rC\u0003l\u0001\u0011\u0005A\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0003}\u0001\u0011\u0005Q\u0010C\u0004\u0002\b\u0001!I!!\u0003\u0003+\u0019{G\u000eZ3s-\u0006\u0014\u0018.\u00192mKN+'O^5dK*\u0011abD\u0001\bg\u0016\u0014h/[2f\u0015\t\u0001\u0012#A\u0005yYJ,G.Z1tK*\u0011!cE\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001F\u0001\u0004G>l7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017\u0001\u00054pY\u0012,'OU3q_NLGo\u001c:z!\ty\"%D\u0001!\u0015\t\ts\"\u0001\u0006sKB|7/\u001b;pefL!a\t\u0011\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018\u0001\u00074pY\u0012,'OV1sS\u0006\u0014G.\u001a*fa>\u001c\u0018\u000e^8ssB\u0011qDJ\u0005\u0003O\u0001\u0012\u0001DR8mI\u0016\u0014h+\u0019:jC\ndWMU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0010\u0003\u0019)g/\u001a8ug&\u0011af\u000b\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u00032gQ*\u0004C\u0001\u001a\u0001\u001b\u0005i\u0001\"B\u000f\u0005\u0001\u0004q\u0002\"\u0002\u0013\u0005\u0001\u0004)\u0003\"\u0002\u0015\u0005\u0001\u0004I\u0003F\u0001\u00038!\tA4)D\u0001:\u0015\tQ4(\u0001\u0006b]:|G/\u0019;j_:T!\u0001P\u001f\u0002\u000f\u0019\f7\r^8ss*\u0011ahP\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0001\u0006\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011K$!C!vi><\u0018N]3e\u0003!1\u0017N\u001c3Cs&#GCA$P!\tAU*D\u0001J\u0015\tQ5*A\u0005wCJL\u0017M\u00197fg*\u0011AjD\u0001\u0007I>l\u0017-\u001b8\n\u00059K%\u0001\u0003,be&\f'\r\\3\t\u000bA+\u0001\u0019A)\u0002\u0015Y\f'/[1cY\u0016LE\r\u0005\u0002S3:\u00111k\u0016\t\u0003)fi\u0011!\u0016\u0006\u0003-V\ta\u0001\u0010:p_Rt\u0014B\u0001-\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005aK\u0002FA\u0003^!\tqF-D\u0001`\u0015\tQ\u0004M\u0003\u0002bE\u00069Q.\u001a;sS\u000e\u001c(BA2\u0014\u0003!\u0019w\u000eZ1iC2,\u0017BA3`\u0005\u0015!\u0016.\\3e\u0003Q\u0019'/Z1uK\u001a{G\u000eZ3s-\u0006\u0014\u0018.\u00192mKR\u0011q\t\u001b\u0005\u0006S\u001a\u0001\raR\u0001\tm\u0006\u0014\u0018.\u00192mK\"\u0012a!X\u0001\u001aO\u0016$\u0018\t\u001c7Ge>l\u0017*\\7fI&\fG/\u001a)be\u0016tG\u000f\u0006\u0002naB\u0011\u0001J\\\u0005\u0003_&\u0013qBR8mI\u0016\u0014h+\u0019:jC\ndWm\u001d\u0005\u0006c\u001e\u0001\r!U\u0001\u0011m\u0006\u0014\u0018.\u00192mKB\u000b'/\u001a8u\u0013\u0012D#aB/\u0002%\u001d,G/\u00117m\rJ|W.\u00118dKN$(/\u001f\u000b\u0003[VDQ!\u001d\u0005A\u0002EC#\u0001C/\u0002)U\u0004H-\u0019;f\r>dG-\u001a:WCJL\u0017M\u00197f)\r9\u0015P\u001f\u0005\u0006!&\u0001\r!\u0015\u0005\u0006S&\u0001\ra\u0012\u0015\u0003\u0013u\u000bA\u0003Z3mKR,gi\u001c7eKJ4\u0016M]5bE2,Gc\u0001@\u0002\u0004A\u0011\u0001d`\u0005\u0004\u0003\u0003I\"\u0001B+oSRDQ\u0001\u0015\u0006A\u0002EC#AC/\u0002\u001b\rDWmY6TC6,G+\u001f9f)\u0015q\u00181BA\b\u0011\u0019\tia\u0003a\u0001\u000f\u000691-\u001e:sK:$\bBBA\t\u0017\u0001\u0007q)A\u0004va\u0012\fG/\u001a3)\u0007\u0001\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYbP\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0010\u00033\u0011qaU3sm&\u001cW\r")
public class FolderVariableService {
    private final FolderRepository folderRepository;
    private final FolderVariableRepository folderVariableRepository;
    private final XLReleaseEventBus eventBus;

    @Timed
    public Variable findById(String variableId) {
        return this.folderVariableRepository.findById(variableId);
    }

    @Timed
    public Variable createFolderVariable(Variable variable) {
        String string = variable.getFolderId();
        Option<String> option = IdMatchers$FolderId$.MODULE$.unapply(string);
        if (option.isEmpty()) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(33).append("You can't add variable with id='").append(string).append("'").toString(), new Object[0]);
        }
        String folderId = (String)option.get();
        Checks.checkArgument((boolean)this.folderRepository.exists(folderId), (String)new StringBuilder(31).append("Folder with id='").append(folderId).append("' doesn't exist").toString(), (Object[])new Object[0]);
        variable.checkFolderVariableValidity();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Variable created = this.folderVariableRepository.create(variable);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableCreatedEvent(created, null));
        return created;
    }

    @Timed
    public FolderVariables getAllFromImmediateParent(String variableParentId) {
        return new FolderVariables(variableParentId, this.folderVariableRepository.getAllFromParent(variableParentId));
    }

    @Timed
    public FolderVariables getAllFromAncestry(String variableParentId) {
        return new FolderVariables(variableParentId, this.folderVariableRepository.getAllFromAncestry(variableParentId));
    }

    @Timed
    public Variable updateFolderVariable(String variableId, Variable variable) {
        variable.checkFolderVariableValidity();
        Variable current = this.folderVariableRepository.findById(variableId);
        this.checkSameType(current, variable);
        String string = current.getFolderId();
        String string2 = variable.getFolderId();
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Cannot change folderId", (Object[])new Object[0]);
        if (variable.getValueProvider() != null) {
            variable.getValueProvider().setVariable(variable);
        }
        Variable updated = this.folderVariableRepository.update(variable);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableUpdatedEvent(variable, updated, null));
        return updated;
    }

    @Timed
    public void deleteFolderVariable(String variableId) {
        Variable variable = this.findById(variableId);
        this.folderVariableRepository.delete(variableId);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableDeletedEvent(variable, null));
    }

    private void checkSameType(Variable current, Variable updated) {
        if (!current.getType().equals((Object)updated.getType())) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Cannot change type of variable ").append(updated.getId()).append(" from ").append(current.getType()).append(" to ").append(updated.getType()).toString());
        }
    }

    @Autowired
    public FolderVariableService(FolderRepository folderRepository, FolderVariableRepository folderVariableRepository, XLReleaseEventBus eventBus) {
        this.folderRepository = folderRepository;
        this.folderVariableRepository = folderVariableRepository;
        this.eventBus = eventBus;
    }
}

