/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.codahale.metrics.Timer;
import com.codahale.metrics.jetty9.InstrumentedConnectionFactory;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.license.LicenseRegistrationServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.spring.configuration.XlrWebApplicationInitializer;
import java.lang.management.ManagementFactory;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.CountDownLatch;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionTrackingMode;
import nl.javadude.t2bus.Subscribe;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class XLReleaseServer {
    private static final String KEYSTORE_PROPERTY = "javax.net.ssl.keyStore";
    private static final String KEYSTORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    private static final String TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    private final ServerConfiguration serverConfiguration;
    private final String name;
    private final String springConfig;
    private final XLReleaseServerLaunchOptions launchOptions;
    private Server jettyServer;
    private WebAppContext contextRoot;
    private static volatile CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final XlrConfig bootConfig = XlrConfig.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseServer.class);

    public XLReleaseServer(String name, ServerConfiguration configuration, String springConfig, String contextPath, XLReleaseServerLaunchOptions launchOptions) {
        this.serverConfiguration = configuration;
        this.name = name;
        this.springConfig = springConfig;
        this.launchOptions = launchOptions;
        this.setupJetty(contextPath);
        XLReleaseServer.bootPlugins();
        this.setupLogbackFilter();
        this.setupSpring();
        this.setupAccessLog();
        this.setupRest();
        this.setupRegistrationPage();
        this.setupExtensionApi();
        this.setupVersionEnforcer();
    }

    private void setupJetty(String contextPath) {
        int port = this.serverConfiguration.getHttpPort();
        String documentRootPackage = "web";
        logger.debug("Setting up Jetty.");
        this.jettyServer = new Server((ThreadPool)this.buildThreadPool());
        ServerConnector connector = this.serverConfiguration.isSsl() ? this.setupSSL() : new ServerConnector(this.jettyServer, new ConnectionFactory[]{this.httpConnectionFactory()});
        connector.setIdleTimeout(30000L);
        connector.setHost(this.serverConfiguration.getHttpBindAddress());
        connector.setPort(port);
        connector.getConnectionFactories().stream().filter(x -> x instanceof HttpConnectionFactory).forEach(x -> ((HttpConnectionFactory)x).getHttpConfiguration().setSendServerVersion(false));
        this.jettyServer.addConnector((Connector)connector);
        this.jettyServer.setStopTimeout(1000L);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.jettyServer.addEventListener((Container.Listener)mbContainer);
        this.jettyServer.addBean((Object)mbContainer);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(false);
        this.contextRoot = new WebAppContext((HandlerContainer)this.jettyServer, contextPath, this.newSessionHandler(), (SecurityHandler)new ConstraintSecurityHandler(), new ServletHandler(), errorHandler, 0);
        if (this.bootConfig.metrics().enabled()) {
            this.enableInstrumentedHandler();
        }
        if (this.bootConfig.server_http_gzip_enabled()) {
            this.enableGzipHandler();
        }
    }

    private SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration.isSsl()) {
            logger.debug("Setting up Secure Cookie Enabled to - " + this.serverConfiguration.isSecureCookieEnabled());
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration.isSecureCookieEnabled());
        }
        return sessionHandler;
    }

    private void enableGzipHandler() {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setCompressionLevel(this.bootConfig.server_http_gzip_compression());
        gzipHandler.setMinGzipSize(this.bootConfig.server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths(this.bootConfig.server_http_gzip_excludedPaths().toArray(new String[this.bootConfig.server_http_gzip_excludedPaths().size()]));
        this.jettyServer.insertHandler((HandlerWrapper)gzipHandler);
    }

    private void enableInstrumentedHandler() {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry.metricRegistry());
        this.jettyServer.insertHandler((HandlerWrapper)handler);
    }

    private ServerConnector setupSSL() {
        logger.debug("Setting up Jetty to use SSL");
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(this.serverConfiguration.getKeyStorePath());
        sslContextFactory.setKeyStorePassword(this.serverConfiguration.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(this.serverConfiguration.getKeyStoreKeyPassword());
        String protocol = this.serverConfiguration.getSslProtocol();
        if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
            sslContextFactory.setProtocol(protocol);
        }
        if (this.serverConfiguration.isMutualSsl()) {
            logger.debug("Setting up Jetty to use mutual SSL");
            sslContextFactory.setNeedClientAuth(true);
            sslContextFactory.setTrustStorePath(this.serverConfiguration.getTrustStorePath());
            sslContextFactory.setTrustStorePassword(this.serverConfiguration.getTrustStorePassword());
        }
        return new ServerConnector(this.jettyServer, this.sslConnectionFactory(sslContextFactory));
    }

    private ConnectionFactory httpConnectionFactory() {
        HttpConnectionFactory connectionFactory = new HttpConnectionFactory(new HttpConfiguration(), HttpCompliance.RFC2616);
        if (this.bootConfig.metrics().enabled()) {
            Timer timer = XlrMetricRegistry.metricRegistry().timer("connections");
            connectionFactory = new InstrumentedConnectionFactory((ConnectionFactory)connectionFactory, timer);
        }
        return connectionFactory;
    }

    private ConnectionFactory[] sslConnectionFactory(SslContextFactory sslContextFactory) {
        return AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{this.httpConnectionFactory()});
    }

    private QueuedThreadPool buildThreadPool() {
        int maxThreads = this.serverConfiguration.getMaxThreads();
        int minThreads = this.serverConfiguration.getMinThreads();
        return new QueuedThreadPool(maxThreads, minThreads);
    }

    private static void bootPlugins() {
        LocalBooter.boot();
    }

    private void setupSpring() {
        XLReleaseServer.setPropertyIfNull(KEYSTORE_PROPERTY, this.serverConfiguration.getKeyStorePath());
        XLReleaseServer.setPropertyIfNull(KEYSTORE_PASSWORD_PROPERTY, this.serverConfiguration.getKeyStorePassword());
        XLReleaseServer.setPropertyIfNull(TRUSTSTORE_PROPERTY, this.serverConfiguration.getTrustStorePath());
        XLReleaseServer.setPropertyIfNull(TRUSTSTORE_PASSWORD_PROPERTY, this.serverConfiguration.getTrustStorePassword());
        ServerConfiguration.setInstance((ServerConfiguration)this.serverConfiguration);
        XLReleaseServerLaunchOptions.setInstance(this.launchOptions);
        this.contextRoot.getInitParams().put("contextConfigLocation", this.springConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + this.springConfig);
        }
        this.contextRoot.getInitParams().put("contextClass", XmlWebApplicationContext.class.getName());
        this.contextRoot.getInitParams().put("contextInitializerClasses", XlrWebApplicationInitializer.class.getName());
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        this.contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
    }

    private static void setPropertyIfNull(String key, String value) {
        if (value != null) {
            if (System.getProperty(key) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting system property - " + key);
                }
                System.setProperty(key, value);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Not overriding already specified system property - " + key);
            }
        }
    }

    private void setupRest() {
        this.setupCorsFilter();
        this.setupXssSecurityHeadersFilter();
        this.setupSlowdownFilter();
        this.contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        this.contextRoot.addEventListener((EventListener)new DeployitSpringContextLoaderListener());
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        this.contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/");
        this.contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        this.contextRoot.addServlet(servletHolder, "/*");
        this.contextRoot.setResourceBase(".");
    }

    private void setupCorsFilter() {
        if (this.bootConfig.api_corsEnabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            this.contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupXssSecurityHeadersFilter() {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        this.contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupRegistrationPage() {
        String path = "static/0/";
        ServletHolder servlet = new ServletHolder(LicenseRegistrationServlet.class);
        servlet.setInitParameter("productName", "XL Release");
        servlet.setInitParameter("productLogoUrl", "static/0/styles/img/xl-release-logo-purple.svg");
        servlet.setInitParameter("fontLocationEot", "static/0/styles/fonts/open-sans/OpenSans-Regular-webfont.eot");
        servlet.setInitParameter("fontLocationTtf", "static/0/styles/fonts/open-sans/OpenSans-Regular-webfont.ttf");
        servlet.setInitParameter("favicon", "static/0/styles/img/favicon.ico");
        servlet.setInitParameter("faviconType", "image/x-icon");
        servlet.setInitParameter("activationUrl", "https://xebialabs.com/products/xl-release/trial/activation");
        this.contextRoot.addServlet(servlet, "/productregistration/*");
    }

    private void setupExtensionApi() {
        String apiExtensionRootPath = this.bootConfig.serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(AkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        this.contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        this.contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer() {
        if (!Environment.isDevelopment()) {
            this.contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupSlowdownFilter() {
        long slowDownInMs;
        if (Environment.isDevelopment() && (slowDownInMs = this.bootConfig.development_restSlowDownDelay().toMillis()) > 0L) {
            logger.warn("Configuring slow down filter with {} milliseconds.", (Object)slowDownInMs);
            FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
            slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
            this.contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupLogbackFilter() {
        this.contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupAccessLog() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        this.contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    public void start(long startTimestamp) {
        try {
            EventBusHolder.register((Object)this);
            logger.info("Starting Jetty on port {}.", (Object)this.serverConfiguration.getHttpPort());
            this.createShutdownEventThreadAndShutdownHook();
            this.jettyServer.start();
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            if (!this.isShutdownInitiated()) {
                long startupSeconds = (System.currentTimeMillis() - startTimestamp) / 1000L;
                logger.info("{} has started in {} seconds.", (Object)this.name, (Object)startupSeconds);
                logger.info("You can now point your browser to {}\n", (Object)this.serverConfiguration.getServerUrl());
                EventBusHolder.publish((Object)new SystemStartedEvent());
            }
        }
        catch (Error | Exception e) {
            logger.error("Error occurred while starting XL Release", e);
            XLReleaseServer.failBanner(Throwables.getRootCause((Throwable)e).getMessage());
            System.exit(0);
        }
    }

    private static void failBanner(String message) {
        String displayMsg = String.format("XL Release Startup failed: %s%n", message);
        System.err.println();
        System.err.println("################################################################################");
        System.err.println();
        System.err.println(displayMsg);
        System.err.println();
        System.err.println("################################################################################");
        System.err.println();
    }

    private synchronized void stop() {
        if (this.jettyServer.isRunning()) {
            logger.info("Shutting down {}.", (Object)this.name);
            try {
                this.jettyServer.stop();
                logger.info("{} is shutting down.", (Object)this.name);
            }
            catch (Exception e) {
                logger.error("Error occurred while trying to stop Jetty", (Throwable)e);
            }
        }
    }

    private void createShutdownEventThreadAndShutdownHook() {
        Thread shutdownEventThread = new Thread(() -> {
            try {
                shutdownLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            logger.info("Shutting down {} because a shutdown event was received.", (Object)this.name);
            this.stop();
        }, "XLRelease-shutdown-event-thread");
        shutdownEventThread.setDaemon(true);
        shutdownEventThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("Shutting down {} because the process is being terminated.", (Object)this.name);
            EventBusHolder.publish((Object)new ShutdownEvent());
            this.stop();
            logger.info("{} has shut down.", (Object)this.name);
        }));
    }

    private boolean isShutdownInitiated() {
        return shutdownLatch.getCount() == 0L;
    }

    public WebAppContext getContext() {
        return this.contextRoot;
    }

    @Subscribe
    public void shutdownListener(ShutdownEvent event) {
        logger.info("Received shutdown event.");
        shutdownLatch.countDown();
    }
}

