/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.domain.StartWelcomeReleaseEvent;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.events.UserProfileCreatedEvent;
import com.xebialabs.xlrelease.domain.events.UserProfileDeletedEvent;
import com.xebialabs.xlrelease.domain.events.UserProfileUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.repository.UserProfileRepository;
import com.xebialabs.xlrelease.security.SessionService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;

@Service
public class UserProfileService {
    public static final String ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Users";
    private UserProfileRepository userProfileRepository;
    private PrincipalDataProvider principalDataProvider;
    private LicenseService licenseService;
    private SessionService sessionService;
    private XLReleaseEventBus eventBus;
    public static final List<String> ACCEPTED_DATE_FORMATS = Arrays.asList("M/d/yy", "dd/MM/yy", "yy/MM/dd");
    public static final List<String> ACCEPTED_TIME_FORMATS = Arrays.asList("HH:mm", "h:mm a");
    public static final List<Integer> ACCEPTED_FIRST_DAY_OF_WEEK_FORMATS = Arrays.asList(-1, 0, 1);
    private LoadingCache<String, Optional<UserProfile>> userProfilesCache = CacheBuilder.newBuilder().maximumSize(10000L).refreshAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Optional<UserProfile>>(){

        public Optional<UserProfile> load(String canonicalId) {
            List<UserProfile> profiles = UserProfileService.this.userProfileRepository.findById(canonicalId);
            if (profiles.size() > 0) {
                return Optional.of((Object)profiles.get(0));
            }
            return Optional.absent();
        }
    });

    @Autowired
    public UserProfileService(UserProfileRepository userProfileRepository, PrincipalDataProvider principalDataProvider, LicenseService licenseService, SessionService sessionService, XLReleaseEventBus eventBus) {
        this.userProfileRepository = userProfileRepository;
        this.principalDataProvider = principalDataProvider;
        this.licenseService = licenseService;
        this.sessionService = sessionService;
        this.eventBus = eventBus;
    }

    @Timed
    public List<UserProfile> findAll() {
        return this.userProfileRepository.findAll();
    }

    @Timed
    public void deleteByUsername(String username) {
        UserProfile profile = this.findByUsername(username);
        String id = this.toCanonicalId(username);
        this.userProfileRepository.delete(id);
        this.userProfilesCache.invalidate((Object)id);
        this.eventBus.publish((XLReleaseEvent)new UserProfileDeletedEvent(profile));
    }

    @Timed
    public int countUserWithLoginAllowed() {
        return this.userProfileRepository.countUserWithLoginAllowed();
    }

    @Timed
    public List<UserProfile> search(String email, String fullName, Boolean loginAllowed, Date lastActiveAfter, Date lastActiveBefore, Long page, Long resultsPerPage) {
        return this.userProfileRepository.customSearch(email, fullName, loginAllowed, lastActiveAfter, lastActiveBefore, (Option<Object>)Option.apply((Object)page), (Option<Object>)Option.apply((Object)resultsPerPage));
    }

    @Timed
    public UserProfile findByUsername(String username) {
        try {
            return (UserProfile)((Optional)this.userProfilesCache.get((Object)this.toCanonicalId(username))).orNull();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Timed
    public void ensureCreated(String username) {
        this.getOrCreate(username, true);
    }

    @Timed
    public UserProfile discover(String username) {
        return this.getOrCreate(username, false);
    }

    private UserProfile getOrCreate(String username, boolean createIfNotFound) {
        if (this.findByUsername(username) != null) {
            return this.findByUsername(username);
        }
        UserData userData = this.principalDataProvider.getUserData(username);
        if (userData.isFound() || createIfNotFound) {
            UserProfile profile = new UserProfile(username, userData.getEmail(), userData.getFullName(), true);
            this.save(profile);
            return profile;
        }
        return null;
    }

    @Timed
    public void save(UserProfile profile) {
        this.validate(profile);
        this.revokeLoginAllowedAccordingTo(profile, this.licenseService.getLicense());
        if (this.userProfileRepository.exists(profile.getCanonicalId())) {
            this.userProfileRepository.update(Collections.singletonList(profile));
            this.eventBus.publish((XLReleaseEvent)new UserProfileUpdatedEvent(profile));
        } else {
            this.userProfileRepository.create(profile);
            this.eventBus.publish((XLReleaseEvent)new UserProfileCreatedEvent(profile));
        }
        this.userProfilesCache.invalidate((Object)profile.getCanonicalId());
        this.eventBus.publish(new StartWelcomeReleaseEvent(profile.getName()));
    }

    @Timed
    public void updateProfile(UserProfile ... profiles) {
        for (UserProfile userProfile : profiles) {
            this.validate(userProfile);
            this.revokeLoginAllowedAccordingTo(userProfile, this.licenseService.getLicense());
        }
        this.userProfileRepository.update(Arrays.asList(profiles));
        for (UserProfile userProfile : profiles) {
            this.userProfilesCache.invalidate((Object)userProfile.getCanonicalId());
            if (!userProfile.isLoginAllowed()) {
                this.sessionService.disconnect(userProfile.getName());
            }
            this.eventBus.publish((XLReleaseEvent)new UserProfileUpdatedEvent(userProfile));
        }
    }

    @Timed
    public boolean updateLastActive(String canonicalId, Date lastActive) {
        return this.userProfileRepository.updateLastActive(canonicalId, lastActive);
    }

    @Timed
    public int updateLastActiveBatch(Map<String, Date> entries) {
        return this.userProfileRepository.updateLastActiveBatch(entries);
    }

    @Timed
    public void validate(UserProfile profile) {
        Checks.checkArgument((Strings.isBlank((String)profile.getDateFormat()) || ACCEPTED_DATE_FORMATS.contains(profile.getDateFormat()) ? 1 : 0) != 0, (String)"Date format '%s' is not supported", (Object[])new Object[]{profile.getDateFormat()});
        Checks.checkArgument((Strings.isBlank((String)profile.getTimeFormat()) || ACCEPTED_TIME_FORMATS.contains(profile.getTimeFormat()) ? 1 : 0) != 0, (String)"Time format '%s' is not supported", (Object[])new Object[]{profile.getTimeFormat()});
        Checks.checkArgument((profile.getFirstDayOfWeek() == null || ACCEPTED_FIRST_DAY_OF_WEEK_FORMATS.contains(profile.getFirstDayOfWeek()) ? 1 : 0) != 0, (String)"Week start value '%s' is not supported", (Object[])new Object[]{profile.getFirstDayOfWeek()});
    }

    @VisibleForTesting
    void revokeLoginAllowedAccordingTo(UserProfile profile, License license) {
        if (!profile.isLoginAllowed()) {
            return;
        }
        String maxNumberOfUsers = license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS);
        if (maxNumberOfUsers != null && Integer.parseInt(maxNumberOfUsers) <= this.countUserWithLoginAllowed()) {
            profile.setLoginAllowed(false);
        }
    }

    @Timed
    public void clearCache() {
        this.userProfilesCache.invalidateAll();
    }

    private String toCanonicalId(String username) {
        return username.toLowerCase();
    }
}

