/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.Flag;
import java.util.Date;
import java.util.Map;

public class DependencyNode {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String releaseId;
    private String releaseTitle;
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String phaseId;
    private String phaseTitle;
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String taskId;
    private String taskTitle;
    private Flag flag;
    private boolean archived = false;
    private Date startDate;
    private Date endDate;
    private Date scheduledStartDate;
    private Date dueDate;

    public DependencyNode() {
    }

    public DependencyNode(Dependency dependency) {
        if (dependency.hasValidArchiveTargetId()) {
            this.id = dependency.getArchivedTargetId();
        }
        this.archived = dependency.isArchived();
        this.releaseTitle = dependency.getArchivedTargetTitle();
    }

    public DependencyNode(PlanItem item) {
        String itemId = item.getId();
        Release release = item.getRelease();
        this.id = itemId;
        if (item instanceof Release) {
            this.releaseId = itemId;
            this.releaseTitle = item.getTitle();
        } else if (item instanceof Phase) {
            this.releaseId = Ids.releaseIdFrom((String)itemId);
            this.releaseTitle = release.getTitle();
            this.phaseId = itemId;
            this.phaseTitle = VariableHelper.replaceAll((String)item.getTitle(), (Map)release.getAllStringVariableValues());
        } else if (item instanceof Task) {
            Phase phase = ((Task)item).getPhase();
            this.releaseId = Ids.releaseIdFrom((String)itemId);
            this.releaseTitle = release.getTitle();
            this.phaseId = Ids.phaseIdFrom((String)itemId);
            this.phaseTitle = VariableHelper.replaceAll((String)phase.getTitle(), (Map)release.getAllStringVariableValues());
            this.taskId = itemId;
            this.taskTitle = VariableHelper.replaceAll((String)item.getTitle(), (Map)release.getAllStringVariableValues());
        }
        this.startDate = item.getStartDate();
        this.endDate = item.getEndDate();
        this.scheduledStartDate = item.getScheduledStartDate();
        this.dueDate = item.getDueDate();
        this.flag = Flag.toFlag(release);
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getReleaseTitle() {
        return this.releaseTitle;
    }

    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    public String getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(String phaseId) {
        this.phaseId = phaseId;
    }

    public String getPhaseTitle() {
        return this.phaseTitle;
    }

    public void setPhaseTitle(String phaseTitle) {
        this.phaseTitle = phaseTitle;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskTitle() {
        return this.taskTitle;
    }

    public void setTaskTitle(String taskTitle) {
        this.taskTitle = taskTitle;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public String toNodeId() {
        if (this.phaseId == null) {
            return this.releaseId;
        }
        if (this.taskId == null) {
            return this.phaseId;
        }
        return this.taskId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }
}

