package com.xebialabs.xlrelease.storage

import java.io.InputStream
import java.net.URI

trait Storage {
  def put(uri: URI, data: InputStream): URI

  def get(uri: URI): InputStream

  def listDirectories(uri: URI): List[URI]

  def listFiles(uri: URI): List[URI]

  def size(uri: URI): Long

  def delete(uri: URI): Boolean

  def deleteIfEmpty(uri: URI): Boolean

  def uriScheme: String
}
