package com.xebialabs.xlrelease.storage.domain

// this class is a copy of com.xebialabs.xlrelease.repository.Ids
// we made a copy because we do not want dependency on xlr-domain-base that will bring additional dependencies
// (like: com.xebialabs.deployit.engine:engine-xml and com.xebialabs.xl-platform:xl-core)
object IdUtils {
  private val SEPARATOR = "/"
  private val ROOT_FOLDER_ID = "Applications"
  private val FOLDER_PREFIX = "Folder"

  def getFolderlessId(id: String): String = {
    val folderId = findFolderId(id)
    if (isFolderId(folderId) || ROOT_FOLDER_ID == folderId) {
      relativePathFrom(folderId, normalizeId(id))
    } else {
      normalizeId(id)
    }
  }

  private def isFolderId(id: String) = {
    checkIdNotNull(id)
    getName(id).startsWith(FOLDER_PREFIX)
  }

  private def getName(id: String): String = {
    if (id == null || !id.contains(SEPARATOR)) {
      id
    } else {
      id.substring(id.lastIndexOf(SEPARATOR) + 1)
    }
  }

  private def relativePathFrom(fromPath: String, fullPath: String) = if (fullPath == fromPath) {
    ""
  } else if (fullPath.startsWith(fromPath)) {
    fullPath.substring(fromPath.length + 1)
  } else {
    throw new IllegalArgumentException(String.format("'%s' does not contain '%s'", fullPath, fromPath))
  }

  private def checkIdNotNull(id: String): Unit = if (id == null) throw new IllegalArgumentException("ID may not be null")

  private def findFolderId(id: String): String = {
    var parentId = normalizeId(id)
    while ( {
      !isFolderId(parentId) && !isRoot(parentId)
    }) parentId = getParentId(parentId)
    parentId
  }

  private def normalizeId(id: String): String = {
    if (id != null && id.startsWith("/")) {
      id.substring(1)
    } else {
      id
    }
  }

  private def isRoot(id: String) = !id.contains(SEPARATOR)

  private def getParentId(id: String) = {
    if (isRoot(id)) throw new IllegalArgumentException("Not a proper ID for a children: " + id)
    id.substring(0, id.lastIndexOf(SEPARATOR))
  }
}

class IdUtils private() {
}