import React, {useState} from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import "./collapsible.less";

export const CollapsibleComponent = ({children, title, titleButton = null}) => {
    const [isCollapsed, setIsCollapsed] = useState(false);

    const onCollapsibleClick = () => setIsCollapsed(!isCollapsed);

    const renderContent = () => isCollapsed ? null : children;

    return (
        <div className="collapsible-component">
            <div className="collapsible-header">
                <h4
                    className="title cursor-pointer"
                    onClick={onCollapsibleClick}
                >
                    <i className={classNames('xl-icon', {'arrow-down-icon': !isCollapsed, 'arrow-right-icon': isCollapsed})} />
                    {title}
                </h4>
                {titleButton}
            </div>
            <div className="collapsible-content">
                {renderContent()}
            </div>
        </div>
    );
};

CollapsibleComponent.propTypes = {
    children: PropTypes.node.isRequired,
    title: PropTypes.string.isRequired,
    titleButton: PropTypes.element
};
