import React from 'react';
import classNames from 'classnames';
import PropTypes from 'prop-types';
import get from 'lodash/get';

import {isAtRisk, isAttentionNeeded, isOnTrack} from "../../../../features/common/services/risk-detector";


const ICON_CLASSES = {
    completed: 'xl-icon circle-check-icon completed',
    onTrack: 'xl-icon circle-check-icon on-track',
    attentionNeeded: 'xl-icon circle-exclamation-icon attention-needed',
    atRisk: 'xl-icon circle-cross-icon at-risk'
};

const ReleaseRiskStatusIconComponent = ({release, riskConfig}) => {

    const hasCompletedStatus = release => release.status === 'COMPLETED';
    const hasAbortedStatus = release => release.status === 'ABORTED';
    const riskScore = parseInt(get(release, 'syntheticProperties.riskScore'));

    const iconClass = () => {
        if (hasAbortedStatus(release) || hasCompletedStatus(release)) {
            return ICON_CLASSES.completed;
        } else if (isOnTrack(release, riskScore, riskConfig)) {
            return ICON_CLASSES.onTrack;
        } else if (isAttentionNeeded(release, riskScore, riskConfig)) {
            return ICON_CLASSES.attentionNeeded;
        } else if (isAtRisk(release, riskScore, riskConfig)) {
            return ICON_CLASSES.atRisk;
        }
        return '';
    };

    return <i className={classNames('xl-icon', iconClass())}/>;
};

ReleaseRiskStatusIconComponent.propTypes = {
    release: PropTypes.object.isRequired,
    riskConfig: PropTypes.object.isRequired
};

export {ReleaseRiskStatusIconComponent};
