import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Popover} from 'antd';
import classNames from 'classnames';

import './button-with-popover.less';

export const placementList = ['top', 'left', 'right', 'bottom',
    'topLeft', 'topRight', 'bottomLeft', 'bottomRight',
    'leftTop', 'leftBottom', 'rightTop', 'rightBottom'];

export class ButtonWithPopoverComponent extends Component {
    static propTypes = {
        buttonClassName: PropTypes.string,
        content: PropTypes.string.isRequired,
        isDisabled: PropTypes.bool.isRequired,
        isTooltipVisible: PropTypes.bool.isRequired,
        label: PropTypes.oneOfType([
            PropTypes.string,
            PropTypes.element
        ]).isRequired,
        onActionClick: PropTypes.func.isRequired,
        placement: PropTypes.oneOf(placementList).isRequired,
        showAsLink: PropTypes.bool,
    };

    static defaultProps = {
        placement: placementList[0],
    };

    handleClick = (e) => {
        const {isDisabled, onActionClick} = this.props;
        if (!isDisabled) {
            onActionClick(e);
        }
    };

    renderPopoverContent = () => {
        const {content} = this.props;
        return (<div className='bwp-message'>{content}</div>);
    };

    renderLink = () => {
        const {isDisabled, label, buttonClassName} = this.props;
        return (<span className={classNames('link', {[`${buttonClassName}`]: buttonClassName}, {'disabled': isDisabled})}
                      onClick={this.handleClick}>{label}</span>);
    };

    renderButton = () => {
        const {isDisabled, label, buttonClassName} = this.props;
        return (<button className={classNames('button', {[`${buttonClassName}`]: buttonClassName})} disabled={isDisabled}
                        onClick={this.handleClick}>{label}</button>);
    };

    render() {
        const {isTooltipVisible, placement, showAsLink} = this.props;
        const buttonTemplate = (
            <span className={classNames('bwp-button')}>
                {showAsLink ? this.renderLink() : this.renderButton()}
            </span>
        );

        return isTooltipVisible ?
            (<Popover content={this.renderPopoverContent()}
                      mouseEnterDelay={0.5} mouseLeaveDelay={0}
                      overlayClassName='button-with-popover' placement={placement}>{buttonTemplate}</Popover>
            )
            : (buttonTemplate);
    }
}
