import PropTypes from 'prop-types';

export const OrderConst = {
    SORT_ASC: 'asc',
    SORT_DESC: 'desc',
    SORT_NONE: 'none'
};

export const HeaderRow = PropTypes.shape({
    class: PropTypes.string,
    fieldName: PropTypes.string.isRequired,
    label: PropTypes.string.isRequired,
    order: PropTypes.oneOf([OrderConst.SORT_NONE, OrderConst.SORT_DESC, OrderConst.SORT_ASC]),
    sortable: PropTypes.bool.isRequired,
    iteratees: PropTypes.any,
});

export const ReleaseRow = PropTypes.shape({
    currentPhase: PropTypes.string,
    duration: PropTypes.number.isRequired,
    endDate: PropTypes.number.isRequired,
    folders: PropTypes.arrayOf(PropTypes.shape({
        id: PropTypes.string.isRequired,
        title: PropTypes.string.isRequired
    })),
    id: PropTypes.string.isRequired,
    isArchived: PropTypes.bool.isRequired,
    progress: PropTypes.any.isRequired,
    startDate: PropTypes.number.isRequired,
    status: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
});
