import React from 'react';
import PropTypes from 'prop-types';

export const ToggleComponent = ({checked, onChange}) => (
    <label className='xl-ui-switch'>
        <input checked={checked} onChange={(e) => onChange(e.target.checked)} type='checkbox'/>
        <span className='xl-ui-switch-slider round'></span>
    </label>
);

ToggleComponent.propTypes = {
    checked: PropTypes.bool.isRequired,
    onChange: PropTypes.func.isRequired
};
