import React from 'react';
import { mount } from 'enzyme/build';
import { ReleaseProgressComponent } from './release-progress.component';

describe('ReleaseProgressComponent', () => {
    test('should render release progress', () => {
        const completedPercentage = 54.32;
        const releaseProgressComponent = mount(<ReleaseProgressComponent completedPercentage={completedPercentage} />);
        expect(releaseProgressComponent.find('.release-progress-bar-view').text()).toBe('54.32% Completed');
        expect(releaseProgressComponent.find('.release-progress-bar-view > .progress-bar-container > .progress-bar-line').prop('style')).toHaveProperty(
            'width',
            '54.32%',
        );
    });
});
