import React, { Component } from 'react';
import PropTypes from 'prop-types';

import './release-progress.component.less';

export const calculatePercentage = (progress) => {
    if (!progress) {
        return 0;
    }
    const totalTasks = progress.totalTasks;
    const totalRemainingTasks = progress.totalRemainingTasks;
    const tasksFinished = totalTasks - totalRemainingTasks;
    return tasksFinished === 0 ? 0 : Math.round((tasksFinished * 100) / totalTasks);
};

export class ReleaseProgressComponent extends Component {
    static propTypes = {
        completedPercentage: PropTypes.number,
        progress: PropTypes.shape({
            totalTasks: PropTypes.number.isRequired,
            totalRemainingTasks: PropTypes.number.isRequired,
        }),
    };

    render() {
        const { completedPercentage, progress } = this.props;

        let percentage = 0;
        if (completedPercentage) {
            percentage = completedPercentage;
        } else if (progress) {
            percentage = calculatePercentage(progress);
        }

        const barWidthStyle = {
            width: percentage + '%',
        };

        return (
            <div className="release-progress-bar-view">
                <div className="percent-number">{percentage}% Completed</div>
                <div className="progress-bar-container">
                    <div className="progress-bar-line" style={barWidthStyle} />
                </div>
            </div>
        );
    }
}
