import React from 'react';
import PropTypes from 'prop-types';

import { DocLink } from '../index';

export const FolderHeader = ({ filters, actions, documentationPage }) => (
    <div className="header">
        <div className="grey">
            <div className="container-fluid">
                {filters && <div className="filters">{filters}</div>}
                {actions && <div className="buttons">{actions}</div>}
                {documentationPage && <DocLink section={documentationPage} />}
            </div>
        </div>
    </div>
);

FolderHeader.propTypes = {
    actions: PropTypes.node,
    documentationPage: PropTypes.string,
    filters: PropTypes.node,
};
