import React from 'react';
import { DotIcon } from '@digital-ai/dot-components';

import './menu-item.component.less';

interface MenuItemProps {
    iconId?: string;
    label: string;
}

export const MenuItem = ({ label, iconId }: MenuItemProps) => {
    return (
        <div className="menu-item-wrapper">
            {iconId && <DotIcon iconId={iconId} />}
            {label}
        </div>
    );
};
