export interface TaskContainer {
    tasks: Array<Task>;
}

export type TaskStatus =
    | 'IN_PROGRESS'
    | 'PLANNED'
    | 'SKIPPED_IN_ADVANCE'
    | 'COMPLETED_IN_ADVANCE'
    | 'COMPLETED'
    | 'SKIPPED'
    | 'ABORTED'
    | 'PENDING'
    | 'FACET_CHECK_IN_PROGRESS'
    | 'FAILED'
    | 'FAILING'
    | 'FAILURE_HANDLER_IN_PROGRESS'
    | 'ABORT_SCRIPT_IN_PROGRESS'
    | 'PRECONDITION_IN_PROGRESS'
    | 'QUEUED'
    | 'ABORT_SCRIPT_QUEUED'
    | 'WAITING_FOR_INPUT'
    | 'FAILURE_HANDLER_QUEUED';

type ReleaseStatus = 'TEMPLATE' | 'PLANNED' | 'IN_PROGRESS' | 'PAUSED' | 'FAILING' | 'FAILED' | 'COMPLETED' | 'ABORTED';

export interface User {
    fullName?: string;
    username: string;
}

export interface TaskFacet {
    type: string;
}

export interface Task {
    attachments: Array<Attachment>;
    automated: boolean;
    checkAttributes?: boolean;
    color: string | null;
    configurationUri?: string;
    customIconClass?: string;
    customIconLocation?: string;
    delayDuringBlackout: boolean;
    description: string | null;
    dueDate?: number;
    editable: boolean;
    endDate?: number;
    facets: Array<TaskFacet>;
    flag: Flag;
    id: string;
    locked: boolean;
    owner?: User;
    plannedDuration?: number;
    postponedDueToBlackout?: boolean;
    releaseId: string;
    releaseOwner: User;
    scheduledStartDate?: number;
    scriptDefinitionType?: string;
    startDate?: number;
    status: TaskStatus;
    taskFailureHandlerEnabled: boolean;
    team?: string;
    title: string;
    type: string;
    typeDisplayName: string;
    waitForScheduledStartDate?: boolean;
}

export type FlagStatus = 'OK' | 'ATTENTION_NEEDED' | 'AT_RISK';

export interface Flag {
    comment?: string;
    status: FlagStatus;
}

interface GateTaskCondition {
    checked: boolean;
}

interface GateTaskDependency {
    resolved: boolean;
}

export interface GateTask extends Task {
    conditions?: Array<GateTaskCondition>;
    dependencies?: Array<GateTaskDependency>;
}

export interface UserInputTask extends Task {
    updatingVariablesCount?: number;
    variables: Array<Variable>;
}

// eslint-disable-next-line @typescript-eslint/no-empty-interface
export interface Phase extends TaskContainer {
    id: string;
    title: string;
}

export interface TaskGroup extends Task, TaskContainer {}

// eslint-disable-next-line @typescript-eslint/no-empty-interface
export interface SequentialGroup extends TaskGroup {}

export interface ParallelGroup extends TaskGroup {
    links: any;
}

export interface Variable {
    requiresValue: boolean;
    value: any;
}

export interface ReleaseVariable {
    [key: string]: any;
}

interface ReleaseSecurity {
    permissions: Array<string>;
    teams: Array<string>;
}

export interface Release {
    archived: boolean;
    id: string;
    phases: Array<Phase>;
    security: ReleaseSecurity;
    status: ReleaseStatus;
    title: string;
    variables?: ReleaseVariable;
}

export interface Team {
    id: string;
    members: Array<string>;
    permissions: Array<string>;
    roles: Array<string>;
    teamName: string;
    type: string;
}

// com.xebialabs.xlrelease.views.ReleaseTasks
export interface ReleaseTasks {
    id: string;
    status: ReleaseStatus;
    tasks: Array<Task>;
    title: string;
    variables?: ReleaseVariable;
}

export interface Attachment {
    contentType: string;
    filename: string;
    id: string;
}
