import React, { useEffect, useState } from 'react';
import PropTypes from 'prop-types';
import isEmpty from 'lodash/isEmpty';
import map from 'lodash/map';
import classNames from 'classnames';

const PasswordCharacterCode = '\u2022';

const TextAreaPassword = ({ name, onChange, required = false, rows = 4, value }) => {
    const [passwordValue, setPasswordValue] = useState('');
    const [isValid, setValid] = useState(true);

    useEffect(() => {
        const val = isEmpty(value) ? '' : map(value, (_) => PasswordCharacterCode).join('');
        setPasswordValue(val);
        setValidity(val);
    }, []);

    const onValueChange = (event) => {
        const value = event.target.value;
        setPasswordValue(value);
        setValidity(value);
        onChange(value);
    };

    const setValidity = (value) => {
        if (required) {
            return setValid(!isEmpty(value));
        }
        return setValid(true);
    };

    return (
        <div className="password-textarea-component">
            <textarea
                className={classNames('password-textarea', { 'is-invalid': !isValid })}
                name={name}
                onChange={onValueChange}
                spellCheck="false"
                value={passwordValue}
            />
        </div>
    );
};

TextAreaPassword.propTypes = {
    name: PropTypes.string,
    onChange: PropTypes.func.isRequired,
    required: PropTypes.bool,
    rows: PropTypes.number,
    value: PropTypes.any,
};

export { TextAreaPassword, PasswordCharacterCode };
