import React from 'react';
import PropTypes from 'prop-types';
import { DotChip, DotIcon, DotThemeProvider } from '@digital-ai/dot-components';
import './chip.component.less';

export const Chip = ({ text, iconId }) => {
    return (
        <DotThemeProvider>
            <DotChip className="pill-label" isClickable={false} isDeletable={false} size="small" startIcon={<DotIcon iconId={iconId} />}>
                {text}
            </DotChip>
        </DotThemeProvider>
    );
};

Chip.propTypes = {
    iconId: PropTypes.string.isRequired,
    text: PropTypes.string.isRequired,
};
