import { CallEffect, put } from 'redux-saga/effects';
import { Action } from '@reduxjs/toolkit';

export function* withFlagChangingState<R>(effect: CallEffect, setFlag: (_: boolean) => Action, initialFlagValue = true) {
    try {
        yield put(setFlag(initialFlagValue));
        const result: R = yield effect;
        return result;
    } finally {
        yield put(setFlag(!initialFlagValue));
    }
}
