import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import './icon-button.less';

export const IconButton = ({ iconClassName, onButtonClick, buttonTitle, buttonClassNames = [], labelText = '', disabled = false }) => {
    const renderLabel = () => labelText && <span className="icon-button-label">{labelText}</span>;

    return (
        <button className={classNames('icon-button', ...buttonClassNames)} disabled={disabled} onClick={onButtonClick} title={buttonTitle}>
            <i className={classNames('xl-icon', iconClassName)} />
            {renderLabel()}
        </button>
    );
};

IconButton.propTypes = {
    buttonClassNames: PropTypes.arrayOf(PropTypes.string),
    buttonTitle: PropTypes.string,
    disabled: PropTypes.bool,
    iconClassName: PropTypes.string.isRequired,
    labelText: PropTypes.string,
    onButtonClick: PropTypes.func.isRequired,
};
