import React, { useState } from 'react';
import { Select } from 'antd';
import PropTypes from 'prop-types';
import get from 'lodash/get';
import isUndefined from 'lodash/isUndefined';
import isEmpty from 'lodash/isEmpty';
import classNames from 'classnames';

import './select.component.less';

const { Option } = Select;

const SelectComponent = ({ allowClear = false, model, onChange, options, placeholder }) => {
    const [isOpen, setIsOpen] = useState(false);
    const onValueSelect = (value) => onChange(options.find((it) => it.value === value));
    const modelValue = get(model, 'value');
    const suffixIcon = isOpen ? <i className="xl-icon arrow-up-icon" /> : <i className="xl-icon arrow-down-icon" />;
    const placeholderValue = isUndefined(placeholder) ? 'Select value' : placeholder;

    return (
        <Select
            allowClear={allowClear}
            className={classNames('xlr-react-select', { isSelected: !isEmpty(modelValue) })}
            clearIcon={<i className="xl-icon circle-cross-icon" />}
            dropdownClassName="xlr-react-select-dropdown"
            notFoundContent={<span>No options</span>}
            onChange={onValueSelect}
            onDropdownVisibleChange={setIsOpen}
            placeholder={placeholderValue}
            suffixIcon={suffixIcon}
            value={modelValue}
        >
            {options.map((option) => (
                <Option disabled={get(option, 'disabled', false)} key={option.value} value={option.value}>
                    {option.label}
                </Option>
            ))}
        </Select>
    );
};

const SelectItem = PropTypes.shape({
    disabled: PropTypes.bool,
    label: PropTypes.string.isRequired,
    value: PropTypes.string.isRequired,
});

SelectComponent.propTypes = {
    allowClear: PropTypes.bool,
    model: SelectItem,
    onChange: PropTypes.func.isRequired,
    options: PropTypes.arrayOf(SelectItem).isRequired,
    placeholder: PropTypes.string,
};

export { SelectComponent };
