import React from 'react';
import PropTypes from 'prop-types';
import { XlReactWidgetConfirmationDialog } from 'xl-react-components';

export const ConfirmationDialog = ({ isOpen, onConfirm, onCancel, title = 'Confirm', message = 'Please confirm the action', confirmationLabel = 'OK' }) => {
    const confirmationButton = {
        action: 'confirm',
        className: 'button primary',
        keyCodes: [13],
        label: confirmationLabel,
    };
    const cancelButton = {
        action: 'cancel',
        className: 'button cancel',
        keyCodes: [27],
        label: 'Cancel',
    };

    const onButtonClick = (action) => {
        if (action === confirmationButton.action) {
            onConfirm();
        } else {
            onCancel();
        }
    };

    return (
        <XlReactWidgetConfirmationDialog
            buttons={[confirmationButton, cancelButton]}
            dialogClassName="xl-default-modal"
            onButtonClick={onButtonClick}
            show={isOpen}
            title={title}
        >
            {message}
        </XlReactWidgetConfirmationDialog>
    );
};

ConfirmationDialog.propTypes = {
    confirmationLabel: PropTypes.string,
    isOpen: PropTypes.bool.isRequired,
    message: PropTypes.node,
    onCancel: PropTypes.func.isRequired,
    onConfirm: PropTypes.func.isRequired,
    title: PropTypes.string,
};
