import React from 'react';
import { mount } from 'enzyme/build';
import { OrderConst } from './const';
import { ReleaseHeaderLabelComponent } from './release-header-label.component';

describe('ReleaseRowHeaderComponent', () => {
    const header = [
        {
            label: 'Release',
            fieldName: 'title',
            class: 'release-title',
            sortable: false,
        },
        {
            label: 'Status',
            fieldName: 'status',
            class: 'release-status',
            sortable: true,
            order: OrderConst.SORT_NONE,
        },
        {
            label: 'Progress',
            fieldName: 'progress',
            class: 'release-progress',
            sortable: true,
            order: OrderConst.SORT_NONE,
        },
        {
            label: 'Start date',
            fieldName: 'start-date',
            class: 'release-start-date',
            sortable: true,
            order: OrderConst.SORT_NONE,
        },
        {
            label: 'End date',
            fieldName: 'end-date',
            class: 'release-end-date',
            sortable: true,
            order: OrderConst.SORT_NONE,
        },
        {
            label: 'Duration',
            fieldName: 'durationAuditReportReleaseRowHeaderComponent',
            class: 'release-duration',
            sortable: true,
            order: OrderConst.SORT_NONE,
        },
    ];

    test('should render release header row', () => {
        const onOrderChange = jest.fn();
        const releaseHeaderRow = mount(<ReleaseHeaderLabelComponent header={header} onOrderChange={onOrderChange} />);

        const releaseColumns = releaseHeaderRow.find('.release-row-view-column');
        releaseColumns.forEach((node, idx) => {
            expect(node.text()).toBe(header[idx].label);
            if (header[idx].sortable) {
                expect(node.find('.xl-icon.arrow-up-icon').exists()).toBeTruthy();
                expect(node.find('.xl-icon.arrow-down-icon').exists()).toBeTruthy();
            } else {
                expect(node.find('.xl-icon.arrow-up-icon').exists()).toBeFalsy();
                expect(node.find('.xl-icon.arrow-down-icon').exists()).toBeFalsy();
            }
        });
    });

    test('should trigger order change on click', () => {
        const onOrderChange = jest.fn();
        const releaseHeaderRow = mount(<ReleaseHeaderLabelComponent header={header} onOrderChange={onOrderChange} />);

        const releaseColumns = releaseHeaderRow.find('.release-row-view-column');
        const statusColumn = releaseColumns.at(1);
        statusColumn.simulate('click');
        expect(onOrderChange).toHaveBeenCalledWith({ class: 'release-status', fieldName: 'status', label: 'Status', order: 'none', sortable: true });
    });
});
