import React from 'react';
import { Chip } from './chip.component';
import { mountWithTheme } from '../../../../tests/unit/testing-utils';

describe('Chip', () => {
    let wrapper = undefined;

    const defaultProps = {
        iconId: 'template',
        text: 'TEMPLATE',
    };

    const mount = (props = defaultProps) => {
        wrapper = mountWithTheme(<Chip {...props} />);
    };

    it('should render with icon and text', () => {
        mount();
        expect(wrapper.find('.dot-icon .icon-template')).toExist();
        expect(wrapper.text()).toBe('TEMPLATE');
    });

    it('should render chip with the class passed in via prop', () => {
        const className = 'purple';
        mount({ ...defaultProps, className });
        expect(wrapper.find('.dot-chip')).toHaveClassName(className);
    });
});
