import React from 'react';
import { mount } from 'enzyme/build';
import { calculatePercentage, ReleaseProgressComponent } from './release-progress.component';

describe('ReleaseProgressComponent', () => {
    it('should render release progress', () => {
        const completedPercentage = 54.32;
        const releaseProgressComponent = mount(<ReleaseProgressComponent completedPercentage={completedPercentage} />);
        expect(releaseProgressComponent.find('.release-progress-bar-view').text()).toBe('54.32% Completed');
        expect(releaseProgressComponent.find('.release-progress-bar-view > .progress-bar-container > .progress-bar-line').prop('style')).toHaveProperty(
            'width',
            '54.32%',
        );
    });

    it('should return 0 if progress is undefined', () => {
        const progress = undefined;
        const completedPercentage = undefined;

        const releaseProgressComponent = mount(<ReleaseProgressComponent completedPercentage={completedPercentage} progress={progress} />);
        expect(releaseProgressComponent.find('.release-progress-bar-view').text()).toBe('0% Completed');
    });

    describe('calculatePercentage', () => {
        it('should return 0 when progress is undefined', () => {
            expect(calculatePercentage(undefined)).toBe(0);
        });

        it('should return 0 when there are no tasks', () => {
            const progress = { totalTasks: 0, totalRemainingTasks: 0 };
            expect(calculatePercentage(progress)).toBe(0);
        });

        it('should return 100 when all tasks are completed', () => {
            const progress = { totalTasks: 2, totalRemainingTasks: 0 };
            expect(calculatePercentage(progress)).toBe(100);
        });

        it('should return correct percentage when some tasks are completed', () => {
            const progress = { totalTasks: 3, totalRemainingTasks: 1 };
            expect(calculatePercentage(progress)).toBe(66);
        });
        it('should not return 100 when not all tasks are completed', () => {
            const progress = { totalTasks: 1000, totalRemainingTasks: 1 };
            expect(calculatePercentage(progress)).toBe(99);
        });
    });
});
