import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { DotChip, DotIcon, DotThemeProvider } from '@digital-ai/dot-components';
import './chip.component.less';

export const Chip = ({ text, iconId, className }) => {
    return (
        <DotThemeProvider>
            <DotChip
                className={classNames('pill-label', className)}
                isClickable={false}
                isDeletable={false}
                size="small"
                startIcon={<DotIcon iconId={iconId} />}
            >
                {text}
            </DotChip>
        </DotThemeProvider>
    );
};

Chip.propTypes = {
    className: PropTypes.string,
    iconId: PropTypes.string.isRequired,
    text: PropTypes.string.isRequired,
};
