import React from 'react';
import PropTypes from 'prop-types';
import './hightlight-text.less';

export const HighlightText = ({ text, searchText }) => {
    if (!searchText) return text;
    // Function to split text into parts to be rendered
    const highlightText = () => {
        const parts = [];
        let remainingText = text;
        let index = remainingText.toLowerCase().indexOf(searchText.toLowerCase());

        // Loop through the text and find all occurrences of the search term
        while (index !== -1) {
            // Add the text before the match
            if (index > 0) {
                parts.push(remainingText.substring(0, index));
            }

            // Add the matched text with highlighting
            parts.push(
                <span key={`${index}-${remainingText}`} className="highlight-text">
                    {remainingText.substring(index, index + searchText.length)}
                </span>,
            );

            // Update remainingText and index
            remainingText = remainingText.substring(index + searchText.length);
            index = remainingText.toLowerCase().indexOf(searchText.toLowerCase());
        }

        // Add any remaining text after the last match
        if (remainingText) {
            parts.push(remainingText);
        }

        return parts;
    };

    return <div>{highlightText()}</div>;
};

HighlightText.propTypes = {
    text: PropTypes.string,
    searchText: PropTypes.string,
};
