import React from 'react';
import { connect } from 'react-redux';
import { PermissionsTable } from './permissions-table';
import { addTeamToPermission, removeTeamFromPermission } from '../../../features/teams/actions/teams-actions';

const mapStateToProps = (state) => ({
    loading: state.teamsReducers.loading,
    data: state.teamsReducers.permissionsTable,
    readOnly: state.teamsReducers.inherited,
    readOnlyUser: state.teamsReducers.isReadOnlyUser,
    teams: state.teamsReducers.teamsTable,
});

export const PermissionsTableContainer = connect(mapStateToProps, {
    onAddTeam: addTeamToPermission,
    onRemoveTeam: removeTeamFromPermission,
})(PermissionsTable);
