import React from 'react';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { Search, SearchProps } from '@xlr-ui/app/react/components/search/search';

describe('Search component', () => {
    const onFilterChange = jest.fn();
    const defaultValue = 'my value';
    const searchClassNames = ['search-class-1', 'search-class-2'];
    const inputPlaceholder = 'my placeholder';
    let wrapper: ReactWrapper;

    const defaultProps: SearchProps = {
        defaultValue,
        onFilterChange,
        searchClassNames,
        inputPlaceholder,
    };

    const getMainDiv = () => wrapper.find('div.search');
    const getIcon = () => wrapper.find('i.search-icon');
    const getInput = () => wrapper.find('input.search-input');

    const mountComponent = (props = defaultProps) => {
        wrapper = mountWithTheme(<Search {...props} />);
    };

    it('should render PersonalAccessToken wrapped into redux Provider with correct store', () => {
        mountComponent();
        const mainDivProps = getMainDiv().props();
        expect(mainDivProps.className).toEqual('search search-class-1 search-class-2');
        expect(getIcon()).toExist();
        const input = getInput();
        const inputProps = input.props();
        expect(inputProps.autoFocus).toBe(true);
        expect(inputProps.defaultValue).toBe(defaultValue);
        expect(inputProps.placeholder).toBe(inputPlaceholder);
        expect(inputProps.onChange).toEqual(onFilterChange);
        expect(inputProps.type).toEqual('text');
        expect;
    });

    it('should render component with proper values when props with default values are omitted', () => {
        mountComponent({ onFilterChange } as never);
        const mainDivProps = getMainDiv().props();
        expect(mainDivProps.className).toEqual('search');
        expect(getIcon()).toExist();
        const input = getInput();
        const inputProps = input.props();
        expect(inputProps.autoFocus).toBe(true);
        expect(inputProps.defaultValue).toBe('');
        expect(inputProps.placeholder).toBe('');
        expect(inputProps.onChange).toEqual(onFilterChange);
        expect(inputProps.type).toEqual('text');
    });
});
