import React, { ChangeEventHandler } from 'react';
import { DotIcon, DotInputText } from '@digital-ai/dot-components';
import classNames from 'classnames';

export interface SearchProps {
    defaultValue?: string;
    inputId?: string;
    inputPlaceholder: string;
    inputRef?: React.RefObject<HTMLInputElement>;
    onFilterChange?: ChangeEventHandler<HTMLInputElement | HTMLTextAreaElement>;
    searchClassNames: string[];
}

export const Search = ({
    defaultValue = '',
    inputId = 'search-input',
    inputRef,
    onFilterChange,
    searchClassNames = [],
    inputPlaceholder = '',
}: SearchProps) => {
    return (
        <div className={classNames('search', ...searchClassNames)}>
            <DotInputText
                autoFocus={true}
                className="search-input"
                defaultValue={defaultValue}
                id={inputId}
                inputRef={inputRef}
                name="search-input"
                onChange={onFilterChange}
                placeholder={inputPlaceholder}
                startIcon={<DotIcon iconId="search" />}
            />
        </div>
    );
};
