import React from 'react';
import { mount } from 'enzyme';

import { alertType, AlertMessage } from '../../../../app/react/components';

describe('Alert message widget', () => {
    it('should render warning properly', () => {
        const innerComponent = <p>Warning test message</p>;
        const component = mount(<AlertMessage alertType={alertType.WARNING}>{innerComponent}</AlertMessage>);

        expect(component.props().alertType).toBe('warning');
        expect(component.props().children).toBe(innerComponent);
    });

    it('should render info properly', () => {
        const innerComponent = <p>Warning test message</p>;
        const component = mount(<AlertMessage alertType={alertType.INFO}>{innerComponent}</AlertMessage>);

        expect(component.props().alertType).toBe('info');
        expect(component.props().children).toBe(innerComponent);
    });
});
