import React, { FC } from 'react';
import { DotButton, DotLink } from '@digital-ai/dot-components';
import './link-button.component.less';

export interface LinkButtonProps {
    dataTestId?: string;
    href: string;
}

export const LinkButton: FC<LinkButtonProps> = ({ dataTestId, href, children }) => {
    return (
        <DotButton className="link-button" data-testid={dataTestId} tabIndex={-1}>
            <DotLink href={href} underline="none">
                {children}
            </DotLink>
        </DotButton>
    );
};
