import React from 'react';
import PropTypes from 'prop-types';

import './popup.less';

const PopupTrigger = (props) => (
    <div className="popup__trigger">
        <i className="xl-icon options-icon remove-outline" onClick={props.onClick} role="button" tabIndex={-1} />
        {props.children}
    </div>
);

PopupTrigger.propTypes = {
    children: PropTypes.element.isRequired,
    onClick: PropTypes.func.isRequired,
};

export default PopupTrigger;
