import { mentionsRegex } from '../../../../js/util/filters';
import { mentionsTrigger } from '../../../../features/common/components/options-selector/option-selector-input.component';
import { User } from '../../../../types';

export const interpolateLinks = (html: string): string => {
    return html.replace(/<a\s+href="([^"]+)">([^<]+)<\/a>/g, replaceAnchor);
};

const replaceAnchor = (text: string, href: string, link: string) => {
    if (href) {
        const internalRelativePath = href.startsWith('#/');
        const internalAbsolutePath = href.startsWith(document.location.origin);
        const openInNewTab = !internalAbsolutePath && !internalRelativePath;
        if (openInNewTab) {
            return `<a href="${href}" target="_blank">${link}</a>`;
        } else {
            return `<a href="${href}">${link}</a>`;
        }
    }
    return text;
};

export const interpolateUsers = (html: string, users: User[]): string => {
    return html.replace(/<strong>@(?:<a[^>]*>)?(.*?)(?:<\/a>)?<\/strong>/g, replaceUserWithMention(users));
};

const replaceUserWithMention = (users: User[]) => (text: string, userToLookFor: string) => {
    if (userToLookFor) {
        const userToReplace = users.find((u) => u.username === userToLookFor);
        if (userToReplace) {
            return `<span class="mention" title="${userToReplace.username}">@${userToReplace.fullName || userToReplace.username}</span>`;
        }
    }
    return text;
};

export const wrapMentionsText = (textWithMention: string) => {
    return textWithMention.replace(mentionsRegex, (match, username) => {
        const prefix = match.substring(0, match.indexOf(mentionsTrigger));
        return `${prefix}**${mentionsTrigger}${username}**`;
    });
};
