import React from 'react';
import { mount } from 'enzyme/build';
import 'moment-duration-format';

import { ReleaseRowComponent } from './release-row.component';
import { formatDateTime } from '../utils';

describe('ReleaseRowComponent', () => {
    test('should render release row', () => {
        const release = {
            id: 'Releasecc8395aca8dc471ab557a60d0945f2e2',
            title: 'Sample',
            currentPhase: 'Dev',
            startDate: 1557298800000,
            endDate: 1557327600000,
            duration: 324325,
            progress: { totalTasks: 100, totalRemainingTasks: 42 },
            status: 'IN_PROGRESS',
            isArchived: false,
            folders: [
                {
                    id: 'Folder8620f34eee8d428ba3342ca6cbb34e28',
                    title: 'Folder 1',
                },
                {
                    id: 'Folder7fd97ed5e2314d5d81cb94f7ac56aa11',
                    title: 'Folder 2',
                },
            ],
        };

        const releaseRowComponent = mount(
            <ReleaseRowComponent
                currentPhase={release.currentPhase}
                duration={release.duration}
                endDate={release.endDate}
                folders={release.folders}
                id={release.id}
                isArchived={release.isArchived}
                progress={release.progress}
                startDate={release.startDate}
                status={release.status}
                title={release.title}
            />,
        );

        const releaseRow = releaseRowComponent.find('.release-list-row-view');
        expect(releaseRow.find('.release-title > div > a > strong').text()).toBe('Sample');
        expect(releaseRow.find('.release-title > div > a').text()).toBe('Sample - Dev');
        expect(releaseRow.find('.release-title > div > a').prop('href')).toBe('#/releases/Releasecc8395aca8dc471ab557a60d0945f2e2');
        expect(releaseRow.find('.release-status').text()).toBe('In progress');
        expect(releaseRow.find('.release-progress').text()).toContain('58% Completed');
        expect(releaseRow.find('.release-start-date').text()).toBe(formatDateTime(release.startDate, 'YYYY-MM-DD', 'h:mm A'));
        expect(releaseRow.find('.release-end-date').text()).toBe(formatDateTime(release.endDate, 'YYYY-MM-DD', 'h:mm A'));
        expect(releaseRow.find('.release-duration').text()).toBe('0d 0h 5m');
    });
});
