import React, { Component } from 'react';
import PropTypes from 'prop-types';
import capitalize from 'lodash/capitalize';

import './release-status.component.less';

export class ReleaseStatusComponent extends Component {
    static propTypes = {
        isArchived: PropTypes.bool,
        status: PropTypes.string.isRequired,
    };

    getReleaseStatusLabel(releaseStatus) {
        return capitalize(releaseStatus.replace('_', ' '));
    }

    getStatusClassName(releaseStatus) {
        return releaseStatus.toLowerCase();
    }

    render() {
        const { status, isArchived } = this.props;

        return (
            <div className="release-status-view">
                <span className={`release-status-label ${this.getStatusClassName(status)}`}>{this.getReleaseStatusLabel(status)}</span>
                {isArchived && <span className="release-status-label archived">Archived</span>}
            </div>
        );
    }
}
