import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { ReleaseRow } from './const';
import { DisplayDurationComponent } from './display-duration/display-duration.component';
import { FolderPathComponent } from '../folder-path/folder-path.component';
import { ReleaseStatusComponent } from './release-status/release-status.component';
import { ReleaseProgressComponent } from './release-progress/release-progress.component';
import { DisplayDateComponent } from './display-date/display-date.component';
import { DEFAULT_FOLDER_TAB } from '../../../features/folders/folder-constants';
import './release-list-common.component.less';

export class ReleaseRowComponent extends Component {
    static propTypes = {
        dateFormat: PropTypes.string,
        timeFormat: PropTypes.string,
        ...ReleaseRow.isRequired,
    };

    render() {
        const { id, title, status, duration, currentPhase, endDate, progress, startDate, folders, isArchived, dateFormat, timeFormat } = this.props;

        return (
            <div className="release-list-row-view">
                <div className="release-row-view-column release-title">
                    <div>
                        <a href={`#/releases/${id}`}>
                            <strong>{title}</strong>
                            {currentPhase && ` - ${currentPhase}`}
                        </a>
                    </div>
                    {folders && folders.length > 0 && <FolderPathComponent childUri={DEFAULT_FOLDER_TAB} folders={folders} showIcon={true} />}
                </div>
                <div className="release-row-view-column release-status">
                    <ReleaseStatusComponent isArchived={isArchived} status={status} />
                </div>
                <div className="release-row-view-column release-progress">
                    <ReleaseProgressComponent progress={progress} />
                </div>
                <div className="release-row-view-column release-start-date">
                    <DisplayDateComponent date={startDate} dateFormat={dateFormat} isLink={true} timeFormat={timeFormat} />
                </div>
                <div className="release-row-view-column release-end-date">
                    <DisplayDateComponent date={endDate} dateFormat={dateFormat} isLink={true} timeFormat={timeFormat} />
                </div>
                <div className="release-row-view-column release-duration">
                    <DisplayDurationComponent duration={duration} />
                </div>
            </div>
        );
    }
}
