import React from 'react';
import angular from 'angular';
import { DotButton, DotEmptyFilterState, DotEmptyState } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import * as angularAccessor from '@xlr-ui/app/features/common/services/angular-accessor';
import { UploadService } from '@xlr-ui/app/features/tasks/types/angular';
import { lazyInjector } from '@xlr-ui/app/components/angular2react/lazy-injector';
import {
    TemplateListEmptyState,
    TemplateListEmptyStateProps,
} from '@xlr-ui/app/react/components/template-list-empty-state/template-list-empty-state.component';

describe('TemplateListEmptyState', () => {
    let wrapper: ReactWrapper;

    const getAngularServiceSpy = jest.spyOn(angularAccessor, 'default') as unknown as jest.SpyInstance<UploadService, [name: unknown]>;

    const defaultProps: TemplateListEmptyStateProps = {
        filtered: false,
        hasCreateTemplatePermission: true,
        onImportTemplateSuccess: jest.fn(),
    };

    const dispatch = jest.fn();

    const mount = (props = defaultProps) => {
        wrapper = mountWithStoreAndTheme(<TemplateListEmptyState {...props} />, dispatch);
    };

    const getDotEmptyState = () => wrapper.find(DotEmptyState);
    const getDotEmptyFilterState = () => wrapper.find(DotEmptyFilterState);
    const getImportTemplateButton = () => wrapper.find('.empty-state-buttons').find(DotButton).at(0);
    const getNewTemplateButton = () => wrapper.find('.empty-state-buttons').find(DotButton).at(1);

    beforeEach(() => {
        getAngularServiceSpy.mockReturnValue({
            reset: jest.fn(),
        } as never);

        angular.mock.inject(($injector: never) => {
            lazyInjector.$injector = $injector;
        });
    });

    afterEach(() => {
        jest.resetAllMocks();
    });

    it('should render without errors', () => {
        mount();
        expect(wrapper.exists()).toBe(true);
    });

    it('should render DotEmptyFilterState', () => {
        mount({ ...defaultProps, filtered: true });
        expect(getDotEmptyFilterState()).toExist();
    });

    it('should render DotEmptyState and buttons', () => {
        mount();
        const dotEmptyStateProps = getDotEmptyState().props();
        expect(getDotEmptyFilterState()).not.toExist();
        expect(getDotEmptyState()).toExist();
        expect(dotEmptyStateProps.illustrationId).toBe('add-new-grid');
        expect(dotEmptyStateProps.subtitle).toBe('Design a release process template by creating a new one or importing an existing template.');
        expect(dotEmptyStateProps.title).toBe('Create release template');
        expect(getImportTemplateButton().props().type).toBe('text');
        expect(getImportTemplateButton()).toHaveText('Import template');
        expect(getNewTemplateButton()).toHaveText('New template');
    });

    it('should not render buttons on empty state', () => {
        mount({ ...defaultProps, hasCreateTemplatePermission: false });
        expect(getImportTemplateButton()).not.toExist();
        expect(getNewTemplateButton()).not.toExist();
    });
});
