import React, {Component} from 'react';
import PropTypes from 'prop-types';

export class Checkbox extends Component {

    static propTypes = {
        isIndeterminate: PropTypes.bool,
    };

    static defaultProps = {
        isIndeterminate: false,
    };

    constructor(props) {
        super(props);
        this.checkboxRef = React.createRef();
    }

    componentDidMount() {
        this.updateIndeterminateFlag();
    }

    componentDidUpdate(prevProps) {
        if (prevProps.isIndeterminate !== this.props.isIndeterminate) {
            this.updateIndeterminateFlag();
        }
    }

    updateIndeterminateFlag() {
        this.checkboxRef.current.indeterminate = this.props.isIndeterminate;
    }

    render() {
        return (
            <input {..._.omit(this.props, 'isIndeterminate')} ref={this.checkboxRef} type="checkbox" />
        );
    }

}
