import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Popover} from 'antd';
import isUndefined from 'lodash/isUndefined';

import './contex-menu.component.less';

export class ContextMenuComponent extends Component {

    static propTypes = {
        menuName: PropTypes.string,
        menuOptions: PropTypes.arrayOf(PropTypes.shape({
            label: PropTypes.string,
            handler: PropTypes.func,
            isDisabled: PropTypes.bool,
            isVisible: PropTypes.bool
        })),
        menuWrapperClassName: PropTypes.any
    };

    static defaultProps = {
        menuName: '',
        menuOptions: [],
        menuWrapperClassName: ''
    };


    renderMenuContent(menuOptions) {
        return menuOptions.map((item, index) => (isUndefined(item.isVisible) || !!item.isVisible) ?
            !!item.isDisabled ? <a className='link-disabled' key={`menu-item-${index}`}>{item.label}</a>
                : <a key={`menu-item-${index}`} onClick={item.handler}>{item.label}</a> : false);
    }

    renderMenu(stageMenuOptions, menuWrapperClassName, menuName) {
        return (<span className={menuWrapperClassName}>
            <Popover
                arrowPointAtCenter
                content={this.renderMenuContent(stageMenuOptions)}
                overlayClassName='context-menu-popover'
                placement='bottomRight'
                trigger='click'>
                <i className='xl-icon options-icon icon-l context-menu-btn' data-cy={'popup-' + menuName}/>
            </Popover>
        </span>);
    }

    render() {
        const {menuName, menuOptions, menuWrapperClassName} = this.props;

        return this.renderMenu(menuOptions, menuWrapperClassName, menuName);
    }
}
