/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.gatling;

import com.google.common.io.Files;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.PerformanceResultsSummary;
import com.xebialabs.xltest.gatling.JsonParser;
import com.xebialabs.xltest.gatling.Line;
import com.xebialabs.xltest.importers.AbstractPerformanceSummaryResultsImporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class GatlingSimulationLogImporter
extends AbstractPerformanceSummaryResultsImporter {
    private OverthereFile gatlingReportDir;
    private OverthereFile simulationLogFile;
    private String lastLine;
    private String firstLine;
    private long startTime;
    private long endTime;
    private String simulationName;

    public GatlingSimulationLogImporter(OverthereFile gatlingReportDir) throws ImportFailedException {
        this.gatlingReportDir = gatlingReportDir;
        this.simulationLogFile = gatlingReportDir.getFile("simulation.log");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.simulationLogFile.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            this.firstLine = bufferedReader.readLine();
            this.startTime = Line.parseLine(this.firstLine).getStartTime();
            this.simulationName = Line.parseLine(this.firstLine).getSimulationName();
            while ((line = bufferedReader.readLine()) != null) {
                this.lastLine = line;
            }
            this.endTime = Line.parseLine(this.lastLine).getEndTime();
        }
        catch (IOException e) {
            throw new ImportFailedException((Throwable)e);
        }
    }

    public Event createImportStartedEvent(UUID testRunId) {
        return super.createImportStartedEvent(testRunId).setSimulationName(this.simulationName);
    }

    public long getTimestamp() {
        return this.startTime;
    }

    OverthereFile getGatlingReportDir() {
        return this.gatlingReportDir;
    }

    public String getImportablePath() {
        return this.simulationLogFile.getPath();
    }

    public PerformanceResultsSummary constructPerformanceResultsSummary() throws ImportFailedException {
        try {
            File jsonReport = new File(this.gatlingReportDir.getPath() + File.separator + "js" + File.separator + "global_stats.json");
            if (!jsonReport.exists()) {
                throw new FileNotFoundException(jsonReport.getAbsolutePath());
            }
            JsonParser parser = new JsonParser();
            parser.parse(Files.toString((File)jsonReport, (Charset)Charset.defaultCharset()));
            PerformanceResultsSummary performanceResultsSummary = new PerformanceResultsSummary();
            performanceResultsSummary.setEarliestTimestamp(this.startTime);
            performanceResultsSummary.setLatestTimestamp(this.endTime);
            performanceResultsSummary.setTotalNumberOfRequests((long)((Integer)parser.getValue("numberOfRequests.total")).intValue());
            performanceResultsSummary.setTotalNumberOfOkRequests((long)((Integer)parser.getValue("numberOfRequests.ok")).intValue());
            performanceResultsSummary.setTotalNumberOfNotOkRequests((long)((Integer)parser.getValue("numberOfRequests.ko")).intValue());
            performanceResultsSummary.setMinResponseTime((long)((Integer)parser.getValue("minResponseTime.total")).intValue());
            performanceResultsSummary.setMinResponseTimeOk((long)((Integer)parser.getValue("minResponseTime.ok")).intValue());
            performanceResultsSummary.setMinResponseTimeNotOk((long)((Integer)parser.getValue("minResponseTime.ko")).intValue());
            performanceResultsSummary.setMaxResponseTime((long)((Integer)parser.getValue("maxResponseTime.total")).intValue());
            performanceResultsSummary.setMaxResponseTimeOk((long)((Integer)parser.getValue("maxResponseTime.ok")).intValue());
            performanceResultsSummary.setMaxResponseTimeNotOk((long)((Integer)parser.getValue("maxResponseTime.ko")).intValue());
            performanceResultsSummary.setMeanResponseTime((long)((Integer)parser.getValue("meanResponseTime.total")).intValue());
            performanceResultsSummary.setMeanResponseTimeOk((long)((Integer)parser.getValue("meanResponseTime.ok")).intValue());
            performanceResultsSummary.setMeanResponseTimeNotOk((long)((Integer)parser.getValue("meanResponseTime.ko")).intValue());
            performanceResultsSummary.setStandardDeviation((double)((Integer)parser.getValue("standardDeviation.total")).intValue());
            performanceResultsSummary.setStandardDeviationOk((double)((Integer)parser.getValue("standardDeviation.ok")).intValue());
            performanceResultsSummary.setStandardDeviationNotOk((double)((Integer)parser.getValue("standardDeviation.ko")).intValue());
            HashMap<String, Object> otherProperties = new HashMap<String, Object>();
            this.parsePercentilesAndPutOnMap(parser, otherProperties, "percentiles1");
            this.parsePercentilesAndPutOnMap(parser, otherProperties, "percentiles2");
            this.parseGroupAndPutOnMap(parser, otherProperties, "group1");
            this.parseGroupAndPutOnMap(parser, otherProperties, "group2");
            this.parseGroupAndPutOnMap(parser, otherProperties, "group3");
            this.parseGroupAndPutOnMap(parser, otherProperties, "group4");
            performanceResultsSummary.setOtherProperties(otherProperties);
            return performanceResultsSummary;
        }
        catch (IOException | RuntimeException e) {
            throw new ImportFailedException((Throwable)e);
        }
    }

    private void parsePercentilesAndPutOnMap(JsonParser parser, Map<String, Object> otherProperties, String key) {
        otherProperties.put(key + ".total", (Integer)parser.getValue(key + ".total"));
        otherProperties.put(key + ".ok", (Integer)parser.getValue(key + ".ok"));
        otherProperties.put(key + ".ko", (Integer)parser.getValue(key + ".ko"));
    }

    private void parseGroupAndPutOnMap(JsonParser parser, Map<String, Object> otherProperties, String key) {
        otherProperties.put(key + ".name", (String)parser.getValue(key + ".name"));
        otherProperties.put(key + ".count", (Integer)parser.getValue(key + ".count"));
        otherProperties.put(key + ".percentage", (Integer)parser.getValue(key + ".percentage"));
    }
}

