/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlt.plugin.api.testrun;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event
implements Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(Event.class);
    public static final String ID = "_id";
    public static final String RUN_ID = "@runId";
    public static final String CREATED_AT = "@createdAt";
    public static final String TYPE = "@type";
    public static final String TEST_SPECIFICATION = "@testSpecification";
    public static final String TESTED_AT = "@testedAt";
    public static final String RUN_KEY = "@runKey";
    public static final String TAGS = "@tags";
    @Deprecated
    public static final String EXECUTION_STARTED = "executionStarted";
    @Deprecated
    public static final String EXECUTION_FINISHED = "executionFinished";
    public static final String TYPE_IMPORT_STARTED = "importStarted";
    public static final String TYPE_IMPORT_FINISHED = "importFinished";
    public static final String TYPE_FUNCTIONAL_RESULT = "functionalResult";
    public static final String TYPE_PERFORMANCE_RESULT = "performanceResult";
    public static final String TYPE_UNKNOWN = "UNKNOWN";
    public static final String DURATION = "@duration";
    public static final String RESULT = "@result";
    public static final String FIRST_ERROR = "@firstError";
    public static final String HIERARCHY = "@hierarchy";
    @Deprecated
    public static final String SIMULATION_NAME = "simulationName";
    @Deprecated
    public static final String NUMBER_OF_REQUESTS_TOTAL = "numberOfRequests.total";
    @Deprecated
    public static final String NUMBER_OF_REQUESTS_OK = "numberOfRequests.ok";
    @Deprecated
    public static final String NUMBER_OF_REQUESTS_KO = "numberOfRequests.ko";
    @Deprecated
    public static final String MIN_RESPONSE_TIME_TOTAL = "minResponseTime.total";
    @Deprecated
    public static final String MIN_RESPONSE_TIME_OK = "minResponseTime.ok";
    @Deprecated
    public static final String MIN_RESPONSE_TIME_KO = "minResponseTime.ko";
    @Deprecated
    public static final String MAX_RESPONSE_TIME_TOTAL = "maxResponseTime.total";
    @Deprecated
    public static final String MEAN_RESPONSE_TIME_TOTAL = "meanResponseTime.total";
    @Deprecated
    public static final String MAX_RESPONSE_TIME_OK = "maxResponseTime.ok";
    @Deprecated
    public static final String MAX_RESPONSE_TIME_KO = "maxResponseTime.ko";
    @Deprecated
    public static final String MEAN_RESPONSE_TIME_OK = "meanResponseTime.ok";
    @Deprecated
    public static final String MEAN_RESPONSE_TIME_KO = "meanResponseTime.ko";
    @Deprecated
    public static final String STANDARD_DEVIATION_TOTAL = "standardDeviation.total";
    @Deprecated
    public static final String STANDARD_DEVIATION_OK = "standardDeviation.ok";
    @Deprecated
    public static final String STANDARD_DEVIATION_KO = "standardDeviation.ko";
    @Deprecated
    public static final String CHILD_RUN_ID = "childRunId";
    @Deprecated
    public static final String CHILD_FINISHED = "childFinished";
    @Deprecated
    public static final String CHILD_STARTED = "childStarted";
    private final Map<String, Object> properties = new TreeMap<String, Object>();

    public Event(Map<String, Object> properties) {
        this.properties.putAll(properties);
        if (!this.properties.containsKey(CREATED_AT)) {
            this.update(CREATED_AT, System.currentTimeMillis());
        }
    }

    public Event(String type) {
        this(new HashMap<String, Object>());
        this.update(TYPE, type);
    }

    public Event(String type, Map<String, Object> properties) {
        this(properties);
        this.update(TYPE, type);
    }

    public Event(Event event, Map<String, Object> properties) {
        this(event.getProperties());
        this.properties.putAll(properties);
    }

    public String getType() {
        return (String)this.properties.get(TYPE);
    }

    public boolean isOfType(String type) {
        return this.getType().equals(type);
    }

    public Event update(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public Event updateWithProperties(Map<String, Object> otherProperties) {
        this.properties.putAll(otherProperties);
        return this;
    }

    public <T> T get(String key) {
        Object value = this.properties.get(key);
        return (T)value;
    }

    public <T> T getRequired(String key) {
        T value = this.get(key);
        if (value == null) {
            throw new KeyNotFoundException(this, key);
        }
        return value;
    }

    public boolean hasProperty(String key) {
        return this.properties.get(key) != null;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public static Map<String, Object> props(Map<String, Object> map, Object ... keyValues) {
        assert (keyValues.length % 2 == 0);
        TreeMap<String, Object> m = new TreeMap<String, Object>(map);
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            m.put(keyValues[i].toString(), keyValues[i + 1]);
        }
        return m;
    }

    public static Map<String, Object> props(Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("key value list must have even length. Got: " + Arrays.asList(keyValues));
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            m.put(keyValues[i].toString(), keyValues[i + 1]);
        }
        return m;
    }

    public String getId() {
        return (String)this.get(ID);
    }

    public String getTestSpecificationName() {
        return (String)this.get(TEST_SPECIFICATION);
    }

    public Event setTestSpecificationName(String testSpecificationName) {
        return this.update(TEST_SPECIFICATION, testSpecificationName);
    }

    public Date getTimestampAsDate() {
        return new Date(this.getCreatedAt());
    }

    public long getCreatedAt() {
        return this.getLongFromProperties(CREATED_AT);
    }

    @VisibleForTesting
    public Event setCreatedAt(long timestamp) {
        this.update(CREATED_AT, timestamp);
        return this;
    }

    public Event setTestedAt(long testedAt) {
        return this.update(TESTED_AT, testedAt);
    }

    public long getTestedAt() {
        return this.getLongFromProperties(TESTED_AT);
    }

    public Event setDuration(int totalDuration) {
        return this.update(DURATION, totalDuration);
    }

    public int getDuration() {
        try {
            return this.getIntFromProperties(DURATION);
        }
        catch (ClassCastException e) {
            LOG.error("ClassCastException occurred while retrieving duration. Value of 'duration' is : {}. Of type: {}. Event properties: {}, Stacktrace: {}", new Object[]{this.get(DURATION), this.get(DURATION).getClass(), this.getProperties(), e});
            throw e;
        }
    }

    public String getResult() {
        return (String)this.get(RESULT);
    }

    public Event setResult(String result) {
        return this.update(RESULT, result);
    }

    public String getFirstError() {
        return (String)this.get(FIRST_ERROR);
    }

    public Event setFirstError(String firstError) {
        return this.update(FIRST_ERROR, firstError);
    }

    public long getTotalNumberOfRequests() {
        return this.getLongFromProperties(NUMBER_OF_REQUESTS_TOTAL);
    }

    public Event setTotalNumberOfRequests(long totalNumberOfRequests) {
        return this.update(NUMBER_OF_REQUESTS_TOTAL, totalNumberOfRequests);
    }

    public Event setTotalNumberOfOkRequests(long totalNumberOfOkRequests) {
        return this.update(NUMBER_OF_REQUESTS_OK, totalNumberOfOkRequests);
    }

    public long getTotalNumberOfOkRequests() {
        return this.getLongFromProperties(NUMBER_OF_REQUESTS_OK);
    }

    public Event setTotalNumberOfNotOkRequests(long totalNumberOfNotOkRequests) {
        return this.update(NUMBER_OF_REQUESTS_KO, totalNumberOfNotOkRequests);
    }

    public long getTotalNumberOfNotOkRequests() {
        return this.getLongFromProperties(NUMBER_OF_REQUESTS_KO);
    }

    public Event setMinResponseTime(long minResponseTime) {
        return this.update(MIN_RESPONSE_TIME_TOTAL, minResponseTime);
    }

    public long getMinResponseTime() {
        return this.getLongFromProperties(MIN_RESPONSE_TIME_TOTAL);
    }

    public Event setMinResponseTimeOk(long minResponseTimeOk) {
        return this.update(MIN_RESPONSE_TIME_OK, minResponseTimeOk);
    }

    public long getMinResponseTimeOk() {
        return this.getLongFromProperties(MIN_RESPONSE_TIME_OK);
    }

    public Event setMinResponseTimeNotOk(long minResponseTimeNotOk) {
        return this.update(MIN_RESPONSE_TIME_KO, minResponseTimeNotOk);
    }

    public long getMinResponseTimeNotOk() {
        return this.getLongFromProperties(MIN_RESPONSE_TIME_KO);
    }

    public Event setMaxResponseTime(long maxResponseTime) {
        return this.update(MAX_RESPONSE_TIME_TOTAL, maxResponseTime);
    }

    public long getMaxResponseTime() {
        return this.getLongFromProperties(MAX_RESPONSE_TIME_TOTAL);
    }

    public Event setMaxResponseTimeOk(long maxResponseTimeOk) {
        return this.update(MAX_RESPONSE_TIME_OK, maxResponseTimeOk);
    }

    public long getMaxResponseTimeOk() {
        return this.getLongFromProperties(MAX_RESPONSE_TIME_OK);
    }

    public Event setMaxResponseTimeNotOk(long maxResponseTimeNotOk) {
        return this.update(MAX_RESPONSE_TIME_KO, maxResponseTimeNotOk);
    }

    public long getMaxResponseTimeNotOk() {
        return this.getLongFromProperties(MAX_RESPONSE_TIME_KO);
    }

    public Event setMeanResponseTime(long meanResponseTime) {
        return this.update(MEAN_RESPONSE_TIME_TOTAL, meanResponseTime);
    }

    public long getMeanResponseTime() {
        return this.getLongFromProperties(MEAN_RESPONSE_TIME_TOTAL);
    }

    public Event setMeanResponseTimeOk(long meanResponseTimeOk) {
        return this.update(MEAN_RESPONSE_TIME_OK, meanResponseTimeOk);
    }

    public long getMeanResponseTimeOk() {
        return this.getLongFromProperties(MEAN_RESPONSE_TIME_OK);
    }

    public Event setMeanResponseTimeNotOk(long meanResponseTimeNotOk) {
        return this.update(MEAN_RESPONSE_TIME_KO, meanResponseTimeNotOk);
    }

    public long getMeanResponseTimeNotOk() {
        return this.getLongFromProperties(MEAN_RESPONSE_TIME_KO);
    }

    public double getStandardDeviation() {
        return this.getDoubleFromProperties(STANDARD_DEVIATION_TOTAL);
    }

    public Event setStandardDeviation(double standardDeviation) {
        return this.update(STANDARD_DEVIATION_TOTAL, standardDeviation);
    }

    public double getStandardDeviationOk() {
        return this.getDoubleFromProperties(STANDARD_DEVIATION_OK);
    }

    public Event setStandardDeviationOk(double standardDeviationOk) {
        return this.update(STANDARD_DEVIATION_OK, standardDeviationOk);
    }

    public double getStandardDeviationNotOk() {
        return this.getDoubleFromProperties(STANDARD_DEVIATION_KO);
    }

    public Event setStandardDeviationNotOk(double standardDeviationNotOk) {
        return this.update(STANDARD_DEVIATION_KO, standardDeviationNotOk);
    }

    public Event setSimulationName(String simulationName) {
        return this.update(SIMULATION_NAME, simulationName);
    }

    public String getSimulationName() {
        return (String)this.get(SIMULATION_NAME);
    }

    public Event setFailureReason(String message) {
        return this.update("failureReason", message);
    }

    public String getTestRunId() {
        Object testRunId = this.get(RUN_ID);
        if (testRunId == null) {
            throw new IllegalArgumentException("Event malformed, no valid runId: " + this.toString());
        }
        return testRunId.toString();
    }

    public Event setTestRunId(String testRunId) {
        if (testRunId == null || testRunId.isEmpty()) {
            throw new IllegalArgumentException("testRunId must be non empty.");
        }
        return this.update(RUN_ID, testRunId);
    }

    public Event setRunKey(String runKey) {
        if (runKey == null || runKey.isEmpty()) {
            throw new IllegalArgumentException("runKey must be non empty.");
        }
        return this.update(RUN_KEY, runKey);
    }

    public String getRunKey() {
        return (String)this.get(RUN_KEY);
    }

    private long getLongFromProperties(String key) {
        Object value = this.get(key);
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).intValue();
            }
        }
        return -1L;
    }

    private int getIntFromProperties(String key) {
        Integer value = (Integer)this.get(key);
        if (value != null) {
            return value;
        }
        return -1;
    }

    private double getDoubleFromProperties(String key) {
        Double value = (Double)this.get(key);
        if (value != null) {
            return value;
        }
        return -1.0;
    }

    public Event setTags(List<String> tags) {
        this.updateWithProperties(Collections.singletonMap(TAGS, tags));
        return this;
    }

    public List<String> getTags() {
        List tags = (List)this.get(TAGS);
        if (tags == null) {
            tags = Lists.newArrayList();
        }
        return tags;
    }

    public static Event create(String type, Object ... properties) {
        Event e = new Event(type);
        e.updateWithProperties(Event.props(properties));
        return e;
    }

    public static Event createImportStartedEvent() {
        return Event.create(TYPE_IMPORT_STARTED, new Object[0]);
    }

    public static Event createImportStartedEvent(long testedAt) {
        return Event.create(TYPE_IMPORT_STARTED, TESTED_AT, testedAt);
    }

    public static Event createImportFinishedEvent(int duration) {
        return Event.create(TYPE_IMPORT_FINISHED, DURATION, duration);
    }

    public List<String> getHierarchy() {
        List value = (List)this.get(HIERARCHY);
        if (value != null) {
            return new ArrayList<String>(value);
        }
        return new ArrayList<String>();
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    public boolean isFunctionalResult() {
        return this.getType().equals(TYPE_FUNCTIONAL_RESULT);
    }

    public boolean isResult(String result) {
        return this.getResult().equals(result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return this.properties.equals(event.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public String toString() {
        return "Event" + this.properties;
    }

    private static class KeyNotFoundException
    extends RuntimeException {
        public KeyNotFoundException(Event event, String key) {
            super("key [" + key + "] not found for event " + event);
        }
    }
}

